/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FileDownloadOff: ImageVector
    get() {
        if (_fileDownloadOff != null) {
            return _fileDownloadOff!!
        }
        _fileDownloadOff = materialIcon(name = "Outlined.FileDownloadOff") {
            materialPath {
                moveTo(18.0f, 15.17f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.17f)
                lineTo(18.0f, 15.17f)
                close()
                moveTo(15.41f, 12.59f)
                lineTo(17.0f, 11.0f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(14.0f, 11.17f)
                lineTo(15.41f, 12.59f)
                close()
                moveTo(13.0f, 10.17f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.17f)
                lineTo(13.0f, 10.17f)
                close()
                moveTo(21.19f, 21.19f)
                lineToRelative(-1.78f, -1.78f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(6.19f, 6.19f)
                lineTo(7.0f, 11.0f)
                lineToRelative(5.0f, 5.0f)
                lineToRelative(0.59f, -0.59f)
                lineTo(15.17f, 18.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(11.17f)
                lineToRelative(2.61f, 2.61f)
                lineTo(21.19f, 21.19f)
                close()
            }
        }
        return _fileDownloadOff!!
    }

private var _fileDownloadOff: ImageVector? = null
