/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FilterDrama: ImageVector
    get() {
        if (_filterDrama != null) {
            return _filterDrama!!
        }
        _filterDrama = materialIcon(name = "Rounded.FilterDrama") {
            materialPath {
                moveTo(19.35f, 10.04f)
                curveTo(18.67f, 6.59f, 15.64f, 4.0f, 12.0f, 4.0f)
                curveTo(9.11f, 4.0f, 6.61f, 5.64f, 5.36f, 8.04f)
                curveTo(2.35f, 8.36f, 0.0f, 10.9f, 0.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                curveToRelative(0.0f, -2.64f, -2.05f, -4.78f, -4.65f, -4.96f)
                close()
                moveTo(19.0f, 18.0f)
                horizontalLineTo(6.17f)
                curveToRelative(-2.09f, 0.0f, -3.95f, -1.53f, -4.15f, -3.61f)
                curveTo(1.79f, 12.01f, 3.66f, 10.0f, 6.0f, 10.0f)
                curveToRelative(1.92f, 0.0f, 3.53f, 1.36f, 3.91f, 3.17f)
                curveToRelative(0.1f, 0.48f, 0.5f, 0.83f, 0.98f, 0.83f)
                curveToRelative(0.61f, 0.0f, 1.11f, -0.55f, 0.99f, -1.15f)
                curveToRelative(-0.43f, -2.24f, -2.11f, -4.03f, -4.29f, -4.63f)
                curveToRelative(1.1f, -1.46f, 2.89f, -2.37f, 4.89f, -2.2f)
                curveToRelative(2.88f, 0.25f, 5.01f, 2.82f, 5.01f, 5.71f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(1.37f)
                curveToRelative(1.45f, 0.0f, 2.79f, 0.97f, 3.07f, 2.4f)
                curveToRelative(0.39f, 1.91f, -1.08f, 3.6f, -2.93f, 3.6f)
                close()
            }
        }
        return _filterDrama!!
    }

private var _filterDrama: ImageVector? = null
