/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LunchDining: ImageVector
    get() {
        if (_lunchDining != null) {
            return _lunchDining!!
        }
        _lunchDining = materialIcon(name = "Rounded.LunchDining") {
            materialPath {
                moveTo(3.37f, 14.28f)
                curveToRelative(0.79f, -0.29f, 1.17f, -0.78f, 1.99f, -0.78f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(0.81f, 0.0f, 1.17f, 0.46f, 1.93f, 0.76f)
                curveToRelative(0.67f, 0.26f, 1.39f, -0.25f, 1.39f, -0.96f)
                curveToRelative(0.0f, -0.43f, -0.28f, -0.81f, -0.69f, -0.96f)
                curveToRelative(-0.97f, -0.35f, -1.22f, -0.83f, -2.65f, -0.83f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.55f, 0.0f, -1.96f, 0.63f, -2.68f, 0.89f)
                curveToRelative(-0.39f, 0.14f, -0.65f, 0.52f, -0.65f, 0.94f)
                curveTo(2.01f, 14.03f, 2.71f, 14.52f, 3.37f, 14.28f)
                close()
            }
            materialPath {
                moveTo(2.0f, 19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 9.0f)
                curveToRelative(0.02f, -4.0f, -4.28f, -6.0f, -10.0f, -6.0f)
                curveTo(6.29f, 3.0f, 2.0f, 5.0f, 2.0f, 9.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(18.0f)
                curveTo(21.55f, 10.0f, 22.0f, 9.55f, 22.0f, 9.0f)
                lineTo(22.0f, 9.0f)
                lineTo(22.0f, 9.0f)
                close()
            }
        }
        return _lunchDining!!
    }

private var _lunchDining: ImageVector? = null
