/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PlayForWork: ImageVector
    get() {
        if (_playForWork != null) {
            return _playForWork!!
        }
        _playForWork = materialIcon(name = "TwoTone.PlayForWork") {
            materialPath {
                moveTo(11.0f, 5.0f)
                verticalLineToRelative(5.59f)
                lineTo(7.5f, 10.59f)
                lineToRelative(4.5f, 4.5f)
                lineToRelative(4.5f, -4.5f)
                lineTo(13.0f, 10.59f)
                lineTo(13.0f, 5.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(6.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, 2.21f, -1.79f, 4.0f, -4.0f, 4.0f)
                reflectiveCurveToRelative(-4.0f, -1.79f, -4.0f, -4.0f)
                lineTo(6.0f, 14.0f)
                close()
            }
        }
        return _playForWork!!
    }

private var _playForWork: ImageVector? = null
