/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SportsHandball: ImageVector
    get() {
        if (_sportsHandball != null) {
            return _sportsHandball!!
        }
        _sportsHandball = materialIcon(name = "Outlined.SportsHandball") {
            materialPath {
                moveTo(14.27f, 6.0f)
                curveTo(13.72f, 6.95f, 14.05f, 8.18f, 15.0f, 8.73f)
                curveToRelative(0.95f, 0.55f, 2.18f, 0.22f, 2.73f, -0.73f)
                curveToRelative(0.55f, -0.95f, 0.22f, -2.18f, -0.73f, -2.73f)
                curveTo(16.05f, 4.72f, 14.82f, 5.05f, 14.27f, 6.0f)
                close()
            }
            materialPath {
                moveTo(15.84f, 10.41f)
                curveToRelative(0.0f, 0.0f, -1.63f, -0.94f, -2.6f, -1.5f)
                curveToRelative(-2.38f, -1.38f, -3.2f, -4.44f, -1.82f, -6.82f)
                lineToRelative(-1.73f, -1.0f)
                curveTo(8.1f, 3.83f, 8.6f, 7.21f, 10.66f, 9.4f)
                lineToRelative(-5.15f, 8.92f)
                lineToRelative(1.73f, 1.0f)
                lineToRelative(1.5f, -2.6f)
                lineToRelative(1.73f, 1.0f)
                lineToRelative(-3.0f, 5.2f)
                lineToRelative(1.73f, 1.0f)
                lineToRelative(6.29f, -10.89f)
                curveToRelative(1.14f, 1.55f, 1.33f, 3.69f, 0.31f, 5.46f)
                lineToRelative(1.73f, 1.0f)
                curveTo(19.13f, 16.74f, 18.81f, 12.91f, 15.84f, 10.41f)
                close()
            }
            materialPath {
                moveTo(12.75f, 3.8f)
                curveToRelative(0.72f, 0.41f, 1.63f, 0.17f, 2.05f, -0.55f)
                curveToRelative(0.41f, -0.72f, 0.17f, -1.63f, -0.55f, -2.05f)
                curveToRelative(-0.72f, -0.41f, -1.63f, -0.17f, -2.05f, 0.55f)
                curveTo(11.79f, 2.47f, 12.03f, 3.39f, 12.75f, 3.8f)
                close()
            }
        }
        return _sportsHandball!!
    }

private var _sportsHandball: ImageVector? = null
