/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DirectionsOff: ImageVector
    get() {
        if (_directionsOff != null) {
            return _directionsOff!!
        }
        _directionsOff = materialIcon(name = "Rounded.DirectionsOff") {
            materialPath {
                moveTo(21.71f, 11.29f)
                lineToRelative(-9.0f, -9.0f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(8.21f, 5.38f)
                lineTo(13.0f, 10.17f)
                lineToRelative(0.0f, -2.67f)
                lineToRelative(3.15f, 3.15f)
                curveToRelative(0.2f, 0.2f, 0.2f, 0.51f, 0.0f, 0.71f)
                lineToRelative(-0.98f, 0.98f)
                lineToRelative(3.45f, 3.45f)
                lineToRelative(3.09f, -3.09f)
                curveTo(22.09f, 12.32f, 22.09f, 11.69f, 21.71f, 11.29f)
                close()
            }
            materialPath {
                moveTo(6.79f, 6.79f)
                lineTo(3.51f, 3.51f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.28f, 3.28f)
                lineToRelative(-3.09f, 3.09f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(9.0f, 9.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.09f, -3.09f)
                lineToRelative(3.28f, 3.28f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(6.79f, 6.79f)
                close()
                moveTo(9.99f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.05f, 0.02f, -0.1f, 0.03f, -0.15f)
                lineToRelative(1.97f, 1.97f)
                verticalLineTo(14.0f)
                close()
            }
        }
        return _directionsOff!!
    }

private var _directionsOff: ImageVector? = null
