/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FormatQuote: ImageVector
    get() {
        if (_formatQuote != null) {
            return _formatQuote!!
        }
        _formatQuote = materialIcon(name = "Rounded.FormatQuote") {
            materialPath {
                moveTo(7.17f, 17.0f)
                curveToRelative(0.51f, 0.0f, 0.98f, -0.29f, 1.2f, -0.74f)
                lineToRelative(1.42f, -2.84f)
                curveToRelative(0.14f, -0.28f, 0.21f, -0.58f, 0.21f, -0.89f)
                lineTo(10.0f, 8.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(5.0f, 7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(-1.03f, 2.06f)
                curveToRelative(-0.45f, 0.89f, 0.2f, 1.94f, 1.2f, 1.94f)
                close()
                moveTo(17.17f, 17.0f)
                curveToRelative(0.51f, 0.0f, 0.98f, -0.29f, 1.2f, -0.74f)
                lineToRelative(1.42f, -2.84f)
                curveToRelative(0.14f, -0.28f, 0.21f, -0.58f, 0.21f, -0.89f)
                lineTo(20.0f, 8.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(-1.03f, 2.06f)
                curveToRelative(-0.45f, 0.89f, 0.2f, 1.94f, 1.2f, 1.94f)
                close()
            }
        }
        return _formatQuote!!
    }

private var _formatQuote: ImageVector? = null
