/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ShoppingBasket: ImageVector
    get() {
        if (_shoppingBasket != null) {
            return _shoppingBasket!!
        }
        _shoppingBasket = materialIcon(name = "Sharp.ShoppingBasket") {
            materialPath {
                moveTo(17.21f, 9.0f)
                lineToRelative(-4.39f, -6.57f)
                curveToRelative(-0.4f, -0.59f, -1.27f, -0.59f, -1.66f, 0.0f)
                lineTo(6.77f, 9.0f)
                lineTo(0.69f, 9.0f)
                lineTo(4.0f, 21.0f)
                horizontalLineToRelative(16.02f)
                lineToRelative(3.29f, -12.0f)
                horizontalLineToRelative(-6.1f)
                close()
                moveTo(11.99f, 4.79f)
                lineTo(14.8f, 9.0f)
                lineTo(9.18f, 9.0f)
                lineToRelative(2.81f, -4.21f)
                close()
                moveTo(12.0f, 17.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                close()
            }
        }
        return _shoppingBasket!!
    }

private var _shoppingBasket: ImageVector? = null
