/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Paragliding: ImageVector
    get() {
        if (_paragliding != null) {
            return _paragliding!!
        }
        _paragliding = materialIcon(name = "Outlined.Paragliding") {
            materialPath {
                moveTo(12.0f, 17.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(14.0f, 16.1f, 13.1f, 17.0f, 12.0f, 17.0f)
                close()
                moveTo(15.48f, 17.94f)
                curveTo(14.68f, 18.54f, 14.0f, 19.0f, 12.0f, 19.0f)
                reflectiveCurveToRelative(-2.68f, -0.46f, -3.48f, -1.06f)
                curveTo(8.04f, 17.55f, 7.0f, 16.76f, 7.0f, 14.0f)
                horizontalLineTo(5.0f)
                curveToRelative(0.0f, 2.7f, 0.93f, 4.41f, 2.3f, 5.5f)
                curveToRelative(0.5f, 0.4f, 1.1f, 0.7f, 1.7f, 0.9f)
                verticalLineTo(24.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-3.6f)
                curveToRelative(0.6f, -0.2f, 1.2f, -0.5f, 1.7f, -0.9f)
                curveToRelative(1.37f, -1.09f, 2.3f, -2.8f, 2.3f, -5.5f)
                horizontalLineToRelative(-2.0f)
                curveTo(17.0f, 16.76f, 15.96f, 17.55f, 15.48f, 17.94f)
                close()
                moveTo(23.0f, 4.25f)
                verticalLineToRelative(3.49f)
                curveToRelative(0.0f, 0.8f, -0.88f, 1.26f, -1.56f, 0.83f)
                curveTo(21.3f, 8.48f, 21.16f, 8.39f, 21.0f, 8.31f)
                lineTo(19.0f, 13.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(-1.5f, -6.28f)
                curveTo(14.4f, 6.58f, 13.22f, 6.5f, 12.0f, 6.5f)
                reflectiveCurveTo(9.6f, 6.58f, 8.5f, 6.72f)
                lineTo(7.0f, 13.0f)
                horizontalLineTo(5.0f)
                lineTo(3.0f, 8.31f)
                curveTo(2.84f, 8.39f, 2.7f, 8.48f, 2.56f, 8.57f)
                curveTo(1.88f, 9.0f, 1.0f, 8.55f, 1.0f, 7.74f)
                verticalLineTo(4.25f)
                curveTo(1.0f, 1.9f, 5.92f, 0.0f, 12.0f, 0.0f)
                reflectiveCurveTo(23.0f, 1.9f, 23.0f, 4.25f)
                close()
                moveTo(6.9f, 6.98f)
                curveTo(5.97f, 7.17f, 5.12f, 7.41f, 4.37f, 7.69f)
                lineToRelative(1.51f, 3.55f)
                lineTo(6.9f, 6.98f)
                close()
                moveTo(19.63f, 7.69f)
                curveToRelative(-0.75f, -0.28f, -1.6f, -0.52f, -2.53f, -0.71f)
                lineToRelative(1.02f, 4.25f)
                lineTo(19.63f, 7.69f)
                close()
                moveTo(21.0f, 4.31f)
                curveTo(20.65f, 3.63f, 17.57f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(3.35f, 3.63f, 3.0f, 4.31f)
                verticalLineToRelative(1.77f)
                curveTo(5.34f, 5.07f, 8.56f, 4.5f, 12.0f, 4.5f)
                reflectiveCurveToRelative(6.66f, 0.57f, 9.0f, 1.58f)
                verticalLineTo(4.31f)
                close()
            }
        }
        return _paragliding!!
    }

private var _paragliding: ImageVector? = null
