/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Abc: ImageVector
    get() {
        if (_abc != null) {
            return _abc!!
        }
        _abc = materialIcon(name = "Rounded.Abc") {
            materialPath {
                moveTo(7.25f, 15.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineTo(13.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(0.75f)
                curveTo(4.5f, 14.66f, 4.16f, 15.0f, 3.75f, 15.0f)
                reflectiveCurveTo(3.0f, 14.66f, 3.0f, 14.25f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.25f)
                curveTo(8.0f, 14.66f, 7.66f, 15.0f, 7.25f, 15.0f)
                close()
                moveTo(6.5f, 10.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.5f)
                close()
                moveTo(13.5f, 12.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                curveTo(14.5f, 11.55f, 14.05f, 12.0f, 13.5f, 12.0f)
                close()
                moveTo(11.0f, 10.5f)
                verticalLineToRelative(0.75f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.5f)
                horizontalLineTo(11.0f)
                close()
                moveTo(13.0f, 12.75f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(0.75f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(12.75f)
                close()
                moveTo(21.0f, 10.25f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                curveToRelative(-0.33f, 0.0f, -0.6f, -0.21f, -0.71f, -0.5f)
                lineToRelative(-2.04f, 0.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.04f, 0.0f)
                curveToRelative(0.1f, -0.29f, 0.38f, -0.5f, 0.71f, -0.5f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineTo(14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(10.25f)
                close()
            }
        }
        return _abc!!
    }

private var _abc: ImageVector? = null
