/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PinInvoke: ImageVector
    get() {
        if (_pinInvoke != null) {
            return _pinInvoke!!
        }
        _pinInvoke = materialIcon(name = "Outlined.PinInvoke") {
            materialPath {
                moveTo(22.0f, 12.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(10.0f)
                lineToRelative(0.0f, 2.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineTo(22.0f)
                close()
                moveTo(22.0f, 7.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                curveTo(20.66f, 10.0f, 22.0f, 8.66f, 22.0f, 7.0f)
                close()
                moveTo(9.34f, 12.0f)
                horizontalLineToRelative(2.24f)
                lineToRelative(-2.95f, 2.95f)
                lineToRelative(1.41f, 1.41f)
                lineTo(13.0f, 13.42f)
                verticalLineToRelative(2.24f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.0f)
                horizontalLineTo(9.34f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _pinInvoke!!
    }

private var _pinInvoke: ImageVector? = null
