/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FormatColorText: ImageVector
    get() {
        if (_formatColorText != null) {
            return _formatColorText!!
        }
        _formatColorText = materialIcon(name = "Rounded.FormatColorText") {
            materialPath {
                moveTo(20.0f, 20.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(21.1f, 20.0f, 20.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(7.11f, 17.0f)
                lineTo(7.11f, 17.0f)
                curveToRelative(0.48f, 0.0f, 0.91f, -0.3f, 1.06f, -0.75f)
                lineToRelative(1.01f, -2.83f)
                horizontalLineToRelative(5.65f)
                lineToRelative(0.99f, 2.82f)
                curveTo(15.98f, 16.7f, 16.41f, 17.0f, 16.89f, 17.0f)
                curveToRelative(0.79f, 0.0f, 1.33f, -0.79f, 1.05f, -1.52f)
                lineTo(13.69f, 4.17f)
                curveTo(13.43f, 3.47f, 12.75f, 3.0f, 12.0f, 3.0f)
                reflectiveCurveToRelative(-1.43f, 0.47f, -1.69f, 1.17f)
                lineTo(6.06f, 15.48f)
                curveTo(5.78f, 16.21f, 6.33f, 17.0f, 7.11f, 17.0f)
                close()
                moveTo(11.94f, 5.6f)
                horizontalLineToRelative(0.12f)
                lineToRelative(2.03f, 5.79f)
                horizontalLineTo(9.91f)
                lineTo(11.94f, 5.6f)
                close()
            }
        }
        return _formatColorText!!
    }

private var _formatColorText: ImageVector? = null
