/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoteAlt: ImageVector
    get() {
        if (_noteAlt != null) {
            return _noteAlt!!
        }
        _noteAlt = materialIcon(name = "Sharp.NoteAlt") {
            materialPath {
                moveTo(21.0f, 3.0f)
                horizontalLineToRelative(-6.18f)
                curveTo(14.4f, 1.84f, 13.3f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(9.6f, 1.84f, 9.18f, 3.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(3.0f)
                close()
                moveTo(12.0f, 2.75f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                reflectiveCurveTo(12.41f, 4.25f, 12.0f, 4.25f)
                reflectiveCurveToRelative(-0.75f, -0.34f, -0.75f, -0.75f)
                reflectiveCurveTo(11.59f, 2.75f, 12.0f, 2.75f)
                close()
                moveTo(9.1f, 17.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-2.14f)
                lineToRelative(5.96f, -5.96f)
                lineToRelative(2.12f, 2.12f)
                lineTo(9.1f, 17.0f)
                close()
                moveTo(17.2f, 8.91f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(13.66f, 8.2f)
                lineToRelative(1.41f, -1.41f)
                lineTo(17.2f, 8.91f)
                close()
            }
        }
        return _noteAlt!!
    }

private var _noteAlt: ImageVector? = null
