/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SportsHockey: ImageVector
    get() {
        if (_sportsHockey != null) {
            return _sportsHockey!!
        }
        _sportsHockey = materialIcon(name = "Sharp.SportsHockey") {
            materialPath {
                moveTo(2.0f, 17.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.0f, 0.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(3.0f)
                curveTo(2.45f, 16.0f, 2.0f, 16.45f, 2.0f, 17.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 16.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(4.69f, -0.01f)
                curveToRelative(0.38f, 0.0f, 0.72f, -0.21f, 0.89f, -0.55f)
                lineToRelative(0.87f, -1.9f)
                lineToRelative(-1.59f, -3.48f)
                lineTo(9.0f, 16.0f)
                close()
            }
            materialPath {
                moveTo(21.71f, 16.29f)
                curveTo(21.53f, 16.11f, 21.28f, 16.0f, 21.0f, 16.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(2.0f, 0.0f)
                verticalLineToRelative(-3.0f)
                curveTo(22.0f, 16.72f, 21.89f, 16.47f, 21.71f, 16.29f)
                close()
            }
            materialPath {
                moveTo(13.6f, 12.84f)
                lineTo(17.65f, 4.0f)
                horizontalLineTo(14.3f)
                lineToRelative(-1.76f, 3.97f)
                lineToRelative(-0.49f, 1.1f)
                lineTo(12.0f, 9.21f)
                lineTo(9.7f, 4.0f)
                horizontalLineTo(6.35f)
                lineToRelative(4.05f, 8.84f)
                lineToRelative(1.52f, 3.32f)
                lineTo(12.0f, 16.34f)
                lineToRelative(1.42f, 3.1f)
                curveToRelative(0.17f, 0.34f, 0.51f, 0.55f, 0.89f, 0.55f)
                lineTo(19.0f, 20.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(13.6f, 12.84f)
                close()
            }
        }
        return _sportsHockey!!
    }

private var _sportsHockey: ImageVector? = null
