/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone._4k: ImageVector
    get() {
        if (__4k != null) {
            return __4k!!
        }
        __4k = materialIcon(name = "TwoTone._4k") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.0f, 5.0f)
                lineTo(5.0f, 5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(14.0f)
                lineTo(19.0f, 5.0f)
                close()
                moveTo(12.0f, 13.51f)
                horizontalLineToRelative(-1.0f)
                lineTo(11.0f, 15.0f)
                lineTo(9.5f, 15.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-3.0f)
                lineTo(6.5f, 9.0f)
                lineTo(8.0f, 9.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(1.5f)
                lineTo(9.5f, 9.0f)
                lineTo(11.0f, 9.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.51f)
                close()
                moveTo(18.2f, 15.0f)
                horizontalLineToRelative(-1.7f)
                lineToRelative(-2.0f, -3.0f)
                verticalLineToRelative(3.0f)
                lineTo(13.0f, 15.0f)
                lineTo(13.0f, 9.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.0f, -3.0f)
                horizontalLineToRelative(1.7f)
                lineToRelative(-2.0f, 3.0f)
                lineToRelative(2.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 21.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.89f, -2.0f, -2.0f, -2.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                close()
                moveTo(5.0f, 5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(14.0f)
                lineTo(5.0f, 19.0f)
                lineTo(5.0f, 5.0f)
                close()
                moveTo(11.0f, 9.0f)
                lineTo(9.5f, 9.0f)
                verticalLineToRelative(3.0f)
                lineTo(8.0f, 12.0f)
                lineTo(8.0f, 9.0f)
                lineTo(6.5f, 9.0f)
                verticalLineToRelative(4.5f)
                horizontalLineToRelative(3.0f)
                lineTo(9.5f, 15.0f)
                lineTo(11.0f, 15.0f)
                verticalLineToRelative(-1.49f)
                horizontalLineToRelative(1.0f)
                lineTo(12.0f, 12.0f)
                horizontalLineToRelative(-1.0f)
                close()
                moveTo(16.5f, 9.0f)
                lineToRelative(-2.0f, 3.0f)
                lineToRelative(2.0f, 3.0f)
                horizontalLineToRelative(1.7f)
                lineToRelative(-2.0f, -3.0f)
                lineToRelative(2.0f, -3.0f)
                close()
                moveTo(13.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                lineTo(14.5f, 9.0f)
                close()
            }
        }
        return __4k!!
    }

private var __4k: ImageVector? = null
