/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SignalCellularConnectedNoInternet0Bar: ImageVector
    get() {
        if (_signalCellularConnectedNoInternet0Bar != null) {
            return _signalCellularConnectedNoInternet0Bar!!
        }
        _signalCellularConnectedNoInternet0Bar = materialIcon(name =
                "Filled.SignalCellularConnectedNoInternet0Bar") {
            materialPath {
                moveTo(20.0f, 18.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(20.0f, 22.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(22.0f)
                close()
                moveTo(18.0f, 20.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(2.0f)
                lineTo(22.0f, 2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.83f)
                lineTo(6.83f, 20.0f)
                horizontalLineTo(18.0f)
                close()
            }
        }
        return _signalCellularConnectedNoInternet0Bar!!
    }

private var _signalCellularConnectedNoInternet0Bar: ImageVector? = null
