/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Plagiarism: ImageVector
    get() {
        if (_plagiarism != null) {
            return _plagiarism!!
        }
        _plagiarism = materialIcon(name = "Outlined.Plagiarism") {
            materialPath {
                moveTo(14.0f, 2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 2.0f, 4.0f, 2.9f, 4.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 1.99f, 2.0f)
                horizontalLineTo(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(8.0f)
                lineTo(14.0f, 2.0f)
                close()
                moveTo(18.0f, 20.0f)
                lineTo(6.0f, 20.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(20.0f)
                close()
            }
            materialPath {
                moveTo(9.03f, 11.03f)
                curveToRelative(-1.37f, 1.37f, -1.37f, 3.58f, 0.0f, 4.95f)
                curveToRelative(1.12f, 1.12f, 2.8f, 1.31f, 4.13f, 0.59f)
                lineToRelative(1.88f, 1.88f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-1.88f, -1.88f)
                curveToRelative(0.71f, -1.33f, 0.53f, -3.01f, -0.59f, -4.13f)
                curveTo(12.61f, 9.66f, 10.39f, 9.66f, 9.03f, 11.03f)
                close()
                moveTo(12.56f, 14.56f)
                curveToRelative(-0.59f, 0.59f, -1.54f, 0.59f, -2.12f, 0.0f)
                curveToRelative(-0.59f, -0.59f, -0.59f, -1.54f, 0.0f, -2.12f)
                curveToRelative(0.59f, -0.59f, 1.54f, -0.59f, 2.12f, 0.0f)
                curveTo(13.15f, 13.03f, 13.15f, 13.97f, 12.56f, 14.56f)
                close()
            }
        }
        return _plagiarism!!
    }

private var _plagiarism: ImageVector? = null
