/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoLuggage: ImageVector
    get() {
        if (_noLuggage != null) {
            return _noLuggage!!
        }
        _noLuggage = materialIcon(name = "Sharp.NoLuggage") {
            materialPath {
                moveTo(12.75f, 9.0f)
                verticalLineToRelative(0.92f)
                lineToRelative(1.75f, 1.75f)
                verticalLineTo(9.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(4.17f)
                lineToRelative(3.0f, 3.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(8.83f)
                lineToRelative(3.0f, 3.0f)
                horizontalLineTo(12.75f)
                close()
                moveTo(10.5f, 3.5f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(3.5f)
                close()
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(1.17f)
                lineToRelative(1.61f, 1.61f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(8.0f, 18.0f)
                verticalLineToRelative(-7.17f)
                lineToRelative(1.5f, 1.5f)
                verticalLineTo(18.0f)
                horizontalLineTo(8.0f)
                close()
                moveTo(11.25f, 18.0f)
                verticalLineToRelative(-3.92f)
                lineToRelative(1.5f, 1.5f)
                verticalLineTo(18.0f)
                horizontalLineTo(11.25f)
                close()
            }
        }
        return _noLuggage!!
    }

private var _noLuggage: ImageVector? = null
