/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.ChromeReaderMode",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.ChromeReaderMode",
            "androidx.compose.material.icons.automirrored.twotone.ChromeReaderMode"),
)
public val Icons.TwoTone.ChromeReaderMode: ImageVector
    get() {
        if (_chromeReaderMode != null) {
            return _chromeReaderMode!!
        }
        _chromeReaderMode = materialIcon(name = "TwoTone.ChromeReaderMode") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(13.0f)
                horizontalLineTo(3.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 4.0f)
                lineTo(3.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(13.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(11.0f, 19.0f)
                lineTo(3.0f, 19.0f)
                lineTo(3.0f, 6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(13.0f)
                close()
                moveTo(21.0f, 19.0f)
                horizontalLineToRelative(-8.0f)
                lineTo(13.0f, 6.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(13.0f)
                close()
                moveTo(14.0f, 9.5f)
                horizontalLineToRelative(6.0f)
                lineTo(20.0f, 11.0f)
                horizontalLineToRelative(-6.0f)
                close()
                moveTo(14.0f, 12.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-6.0f)
                close()
                moveTo(14.0f, 14.5f)
                horizontalLineToRelative(6.0f)
                lineTo(20.0f, 16.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
        }
        return _chromeReaderMode!!
    }

private var _chromeReaderMode: ImageVector? = null
