/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.EmojiSymbols: ImageVector
    get() {
        if (_emojiSymbols != null) {
            return _emojiSymbols!!
        }
        _emojiSymbols = materialIcon(name = "Rounded.EmojiSymbols") {
            materialPath {
                moveTo(10.0f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 5.0f, 3.0f, 5.45f, 3.0f, 6.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveTo(11.0f, 5.45f, 10.55f, 5.0f, 10.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 2.0f, 3.0f, 2.45f, 3.0f, 3.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveTo(10.55f, 2.0f, 10.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(20.89f, 13.11f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-6.36f, 6.36f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(6.36f, -6.36f)
                curveTo(21.28f, 14.13f, 21.28f, 13.5f, 20.89f, 13.11f)
                close()
            }
            materialPath {
                moveTo(14.5f, 14.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(19.5f, 19.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(15.5f, 11.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.51f)
                curveTo(16.58f, 6.19f, 16.07f, 6.0f, 15.5f, 6.0f)
                curveTo(14.12f, 6.0f, 13.0f, 7.12f, 13.0f, 8.5f)
                curveTo(13.0f, 9.88f, 14.12f, 11.0f, 15.5f, 11.0f)
                close()
            }
            materialPath {
                moveTo(10.45f, 18.09f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-0.71f, 0.71f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(0.35f, -0.35f)
                curveToRelative(0.98f, -0.98f, 0.98f, -2.56f, 0.0f, -3.54f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.49f, -0.49f, -1.13f, -0.73f, -1.77f, -0.73f)
                curveToRelative(-0.64f, 0.0f, -1.28f, 0.24f, -1.77f, 0.73f)
                curveToRelative(-0.98f, 0.98f, -0.98f, 2.56f, 0.0f, 3.54f)
                lineToRelative(0.35f, 0.35f)
                lineToRelative(-1.06f, 1.06f)
                curveToRelative(-0.98f, 0.98f, -0.98f, 2.56f, 0.0f, 3.54f)
                curveTo(4.22f, 21.76f, 4.86f, 22.0f, 5.5f, 22.0f)
                curveToRelative(0.64f, 0.0f, 1.28f, -0.24f, 1.77f, -0.73f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(0.71f, 0.71f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-0.71f, -0.71f)
                verticalLineToRelative(0.0f)
                lineTo(10.45f, 18.09f)
                close()
                moveTo(5.85f, 14.2f)
                curveToRelative(0.12f, -0.12f, 0.26f, -0.15f, 0.35f, -0.15f)
                reflectiveCurveToRelative(0.23f, 0.03f, 0.35f, 0.15f)
                curveToRelative(0.19f, 0.2f, 0.19f, 0.51f, 0.0f, 0.71f)
                lineToRelative(-0.35f, 0.35f)
                lineTo(5.85f, 14.9f)
                curveToRelative(-0.12f, -0.12f, -0.15f, -0.26f, -0.15f, -0.35f)
                reflectiveCurveTo(5.73f, 14.32f, 5.85f, 14.2f)
                close()
                moveTo(5.85f, 19.85f)
                curveTo(5.73f, 19.97f, 5.59f, 20.0f, 5.5f, 20.0f)
                reflectiveCurveToRelative(-0.23f, -0.03f, -0.35f, -0.15f)
                curveTo(5.03f, 19.73f, 5.0f, 19.59f, 5.0f, 19.5f)
                reflectiveCurveToRelative(0.03f, -0.23f, 0.15f, -0.35f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(0.71f, 0.71f)
                lineTo(5.85f, 19.85f)
                close()
            }
        }
        return _emojiSymbols!!
    }

private var _emojiSymbols: ImageVector? = null
