/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CancelPresentation: ImageVector
    get() {
        if (_cancelPresentation != null) {
            return _cancelPresentation!!
        }
        _cancelPresentation = materialIcon(name = "TwoTone.CancelPresentation") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 19.1f)
                horizontalLineToRelative(18.0f)
                lineTo(21.0f, 4.95f)
                lineTo(3.0f, 4.95f)
                lineTo(3.0f, 19.1f)
                close()
                moveTo(8.0f, 9.36f)
                lineToRelative(1.41f, -1.41f)
                lineTo(12.0f, 10.54f)
                lineToRelative(2.59f, -2.59f)
                lineTo(16.0f, 9.36f)
                lineToRelative(-2.59f, 2.59f)
                lineTo(16.0f, 14.54f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(12.0f, 13.36f)
                lineToRelative(-2.59f, 2.59f)
                lineTo(8.0f, 14.54f)
                lineToRelative(2.59f, -2.59f)
                lineTo(8.0f, 9.36f)
                close()
            }
            materialPath {
                moveTo(21.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(21.0f, 19.0f)
                lineTo(3.0f, 19.0f)
                lineTo(3.0f, 5.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(9.41f, 15.95f)
                lineTo(12.0f, 13.36f)
                lineToRelative(2.59f, 2.59f)
                lineTo(16.0f, 14.54f)
                lineToRelative(-2.59f, -2.59f)
                lineTo(16.0f, 9.36f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(12.0f, 10.54f)
                lineTo(9.41f, 7.95f)
                lineTo(8.0f, 9.36f)
                lineToRelative(2.59f, 2.59f)
                lineTo(8.0f, 14.54f)
                close()
            }
        }
        return _cancelPresentation!!
    }

private var _cancelPresentation: ImageVector? = null
