/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ContactEmergency: ImageVector
    get() {
        if (_contactEmergency != null) {
            return _contactEmergency!!
        }
        _contactEmergency = materialIcon(name = "TwoTone.ContactEmergency") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(2.0f, 19.0f)
                horizontalLineToRelative(0.08f)
                curveToRelative(1.38f, -2.39f, 3.96f, -4.0f, 6.92f, -4.0f)
                reflectiveCurveToRelative(5.54f, 1.61f, 6.92f, 4.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(15.03f, 8.15f)
                lineToRelative(0.75f, -1.3f)
                lineToRelative(1.47f, 0.85f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(1.7f)
                lineToRelative(1.47f, -0.85f)
                lineToRelative(0.75f, 1.3f)
                lineTo(19.5f, 9.0f)
                lineToRelative(1.47f, 0.85f)
                lineToRelative(-0.75f, 1.3f)
                lineToRelative(-1.47f, -0.85f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-1.7f)
                lineToRelative(-1.47f, 0.85f)
                lineToRelative(-0.75f, -1.3f)
                lineTo(16.5f, 9.0f)
                lineTo(15.03f, 8.15f)
                close()
                moveTo(9.0f, 8.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, 1.35f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.35f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveToRelative(-3.0f, -1.35f, -3.0f, -3.0f)
                reflectiveCurveTo(7.35f, 8.0f, 9.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 14.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, -1.35f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.35f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.35f, -3.0f, 3.0f)
                reflectiveCurveTo(7.35f, 14.0f, 9.0f, 14.0f)
                close()
                moveTo(9.0f, 10.0f)
                curveToRelative(0.54f, 0.0f, 1.0f, 0.46f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.46f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.46f, -1.0f, -1.0f)
                reflectiveCurveTo(8.46f, 10.0f, 9.0f, 10.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 3.0f)
                horizontalLineTo(2.0f)
                curveTo(0.9f, 3.0f, 0.0f, 3.9f, 0.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(20.0f)
                curveToRelative(1.1f, 0.0f, 1.99f, -0.9f, 1.99f, -2.0f)
                lineTo(24.0f, 5.0f)
                curveTo(24.0f, 3.9f, 23.1f, 3.0f, 22.0f, 3.0f)
                close()
                moveTo(4.54f, 19.0f)
                curveToRelative(1.1f, -1.22f, 2.69f, -2.0f, 4.46f, -2.0f)
                reflectiveCurveToRelative(3.36f, 0.78f, 4.46f, 2.0f)
                horizontalLineTo(4.54f)
                close()
                moveTo(22.0f, 19.0f)
                horizontalLineToRelative(-6.08f)
                curveToRelative(-1.38f, -2.39f, -3.96f, -4.0f, -6.92f, -4.0f)
                reflectiveCurveToRelative(-5.54f, 1.61f, -6.92f, 4.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(15.78f, 11.15f)
                lineToRelative(1.47f, -0.85f)
                lineToRelative(0.0f, 1.7f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -1.7f)
                lineToRelative(1.47f, 0.85f)
                lineToRelative(0.75f, -1.3f)
                lineToRelative(-1.47f, -0.85f)
                lineToRelative(1.47f, -0.85f)
                lineToRelative(-0.75f, -1.3f)
                lineToRelative(-1.47f, 0.85f)
                lineToRelative(0.0f, -1.7f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 1.7f)
                lineToRelative(-1.47f, -0.85f)
                lineToRelative(-0.75f, 1.3f)
                lineToRelative(1.47f, 0.85f)
                lineToRelative(-1.47f, 0.85f)
                close()
            }
        }
        return _contactEmergency!!
    }

private var _contactEmergency: ImageVector? = null
