/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MiscellaneousServices: ImageVector
    get() {
        if (_miscellaneousServices != null) {
            return _miscellaneousServices!!
        }
        _miscellaneousServices = materialIcon(name = "TwoTone.MiscellaneousServices") {
            materialPath {
                moveTo(14.17f, 13.71f)
                lineToRelative(1.4f, -2.42f)
                curveToRelative(0.09f, -0.15f, 0.05f, -0.34f, -0.08f, -0.45f)
                lineToRelative(-1.48f, -1.16f)
                curveToRelative(0.03f, -0.22f, 0.05f, -0.45f, 0.05f, -0.68f)
                reflectiveCurveToRelative(-0.02f, -0.46f, -0.05f, -0.69f)
                lineToRelative(1.48f, -1.16f)
                curveToRelative(0.13f, -0.11f, 0.17f, -0.3f, 0.08f, -0.45f)
                lineToRelative(-1.4f, -2.42f)
                curveToRelative(-0.09f, -0.15f, -0.27f, -0.21f, -0.43f, -0.15f)
                lineTo(12.0f, 4.83f)
                curveToRelative(-0.36f, -0.28f, -0.75f, -0.51f, -1.18f, -0.69f)
                lineToRelative(-0.26f, -1.85f)
                curveTo(10.53f, 2.13f, 10.38f, 2.0f, 10.21f, 2.0f)
                horizontalLineToRelative(-2.8f)
                curveTo(7.24f, 2.0f, 7.09f, 2.13f, 7.06f, 2.3f)
                lineTo(6.8f, 4.15f)
                curveTo(6.38f, 4.33f, 5.98f, 4.56f, 5.62f, 4.84f)
                lineToRelative(-1.74f, -0.7f)
                curveToRelative(-0.16f, -0.06f, -0.34f, 0.0f, -0.43f, 0.15f)
                lineToRelative(-1.4f, 2.42f)
                curveTo(1.96f, 6.86f, 2.0f, 7.05f, 2.13f, 7.16f)
                lineToRelative(1.48f, 1.16f)
                curveTo(3.58f, 8.54f, 3.56f, 8.77f, 3.56f, 9.0f)
                reflectiveCurveToRelative(0.02f, 0.46f, 0.05f, 0.69f)
                lineToRelative(-1.48f, 1.16f)
                curveTo(2.0f, 10.96f, 1.96f, 11.15f, 2.05f, 11.3f)
                lineToRelative(1.4f, 2.42f)
                curveToRelative(0.09f, 0.15f, 0.27f, 0.21f, 0.43f, 0.15f)
                lineToRelative(1.74f, -0.7f)
                curveToRelative(0.36f, 0.28f, 0.75f, 0.51f, 1.18f, 0.69f)
                lineToRelative(0.26f, 1.85f)
                curveTo(7.09f, 15.87f, 7.24f, 16.0f, 7.41f, 16.0f)
                horizontalLineToRelative(2.8f)
                curveToRelative(0.17f, 0.0f, 0.32f, -0.13f, 0.35f, -0.3f)
                lineToRelative(0.26f, -1.85f)
                curveToRelative(0.42f, -0.18f, 0.82f, -0.41f, 1.18f, -0.69f)
                lineToRelative(1.74f, 0.7f)
                curveTo(13.9f, 13.92f, 14.08f, 13.86f, 14.17f, 13.71f)
                close()
                moveTo(8.81f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(10.81f, 10.1f, 9.91f, 11.0f, 8.81f, 11.0f)
                close()
            }
            materialPath {
                moveTo(21.92f, 18.67f)
                lineToRelative(-0.96f, -0.74f)
                curveToRelative(0.02f, -0.14f, 0.04f, -0.29f, 0.04f, -0.44f)
                curveToRelative(0.0f, -0.15f, -0.01f, -0.3f, -0.04f, -0.44f)
                lineToRelative(0.95f, -0.74f)
                curveToRelative(0.08f, -0.07f, 0.11f, -0.19f, 0.05f, -0.29f)
                lineToRelative(-0.9f, -1.55f)
                curveToRelative(-0.05f, -0.1f, -0.17f, -0.13f, -0.28f, -0.1f)
                lineToRelative(-1.11f, 0.45f)
                curveToRelative(-0.23f, -0.18f, -0.48f, -0.33f, -0.76f, -0.44f)
                lineToRelative(-0.17f, -1.18f)
                curveTo(18.73f, 13.08f, 18.63f, 13.0f, 18.53f, 13.0f)
                horizontalLineToRelative(-1.79f)
                curveToRelative(-0.11f, 0.0f, -0.21f, 0.08f, -0.22f, 0.19f)
                lineToRelative(-0.17f, 1.18f)
                curveToRelative(-0.27f, 0.12f, -0.53f, 0.26f, -0.76f, 0.44f)
                lineToRelative(-1.11f, -0.45f)
                curveToRelative(-0.1f, -0.04f, -0.22f, 0.0f, -0.28f, 0.1f)
                lineToRelative(-0.9f, 1.55f)
                curveToRelative(-0.05f, 0.1f, -0.04f, 0.22f, 0.05f, 0.29f)
                lineToRelative(0.95f, 0.74f)
                curveToRelative(-0.02f, 0.14f, -0.03f, 0.29f, -0.03f, 0.44f)
                curveToRelative(0.0f, 0.15f, 0.01f, 0.3f, 0.03f, 0.44f)
                lineToRelative(-0.95f, 0.74f)
                curveToRelative(-0.08f, 0.07f, -0.11f, 0.19f, -0.05f, 0.29f)
                lineToRelative(0.9f, 1.55f)
                curveToRelative(0.05f, 0.1f, 0.17f, 0.13f, 0.28f, 0.1f)
                lineToRelative(1.11f, -0.45f)
                curveToRelative(0.23f, 0.18f, 0.48f, 0.33f, 0.76f, 0.44f)
                lineToRelative(0.17f, 1.18f)
                curveToRelative(0.02f, 0.11f, 0.11f, 0.19f, 0.22f, 0.19f)
                horizontalLineToRelative(1.79f)
                curveToRelative(0.11f, 0.0f, 0.21f, -0.08f, 0.22f, -0.19f)
                lineToRelative(0.17f, -1.18f)
                curveToRelative(0.27f, -0.12f, 0.53f, -0.26f, 0.75f, -0.44f)
                lineToRelative(1.12f, 0.45f)
                curveToRelative(0.1f, 0.04f, 0.22f, 0.0f, 0.28f, -0.1f)
                lineToRelative(0.9f, -1.55f)
                curveTo(22.03f, 18.86f, 22.0f, 18.74f, 21.92f, 18.67f)
                close()
                moveTo(17.63f, 18.83f)
                curveToRelative(-0.74f, 0.0f, -1.35f, -0.6f, -1.35f, -1.35f)
                reflectiveCurveToRelative(0.6f, -1.35f, 1.35f, -1.35f)
                reflectiveCurveToRelative(1.35f, 0.6f, 1.35f, 1.35f)
                reflectiveCurveTo(18.37f, 18.83f, 17.63f, 18.83f)
                close()
            }
        }
        return _miscellaneousServices!!
    }

private var _miscellaneousServices: ImageVector? = null
