/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PersonSearch: ImageVector
    get() {
        if (_personSearch != null) {
            return _personSearch!!
        }
        _personSearch = materialIcon(name = "Outlined.PersonSearch") {
            materialPath {
                moveTo(10.0f, 12.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveTo(6.0f, 5.79f, 6.0f, 8.0f)
                curveTo(6.0f, 10.21f, 7.79f, 12.0f, 10.0f, 12.0f)
                close()
                moveTo(10.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(8.0f, 9.1f, 8.0f, 8.0f)
                curveTo(8.0f, 6.9f, 8.9f, 6.0f, 10.0f, 6.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 18.0f)
                curveToRelative(0.22f, -0.72f, 3.31f, -2.0f, 6.0f, -2.0f)
                curveToRelative(0.0f, -0.7f, 0.13f, -1.37f, 0.35f, -1.99f)
                curveTo(7.62f, 13.91f, 2.0f, 15.27f, 2.0f, 18.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(9.54f)
                curveToRelative(-0.52f, -0.58f, -0.93f, -1.25f, -1.19f, -2.0f)
                horizontalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(19.43f, 18.02f)
                curveTo(19.79f, 17.43f, 20.0f, 16.74f, 20.0f, 16.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveToRelative(-4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(0.74f, 0.0f, 1.43f, -0.22f, 2.02f, -0.57f)
                curveToRelative(0.93f, 0.93f, 1.62f, 1.62f, 2.57f, 2.57f)
                lineTo(22.0f, 20.59f)
                curveTo(20.5f, 19.09f, 21.21f, 19.79f, 19.43f, 18.02f)
                close()
                moveTo(16.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(18.0f, 17.1f, 17.1f, 18.0f, 16.0f, 18.0f)
                close()
            }
        }
        return _personSearch!!
    }

private var _personSearch: ImageVector? = null
