/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SentimentVerySatisfied: ImageVector
    get() {
        if (_sentimentVerySatisfied != null) {
            return _sentimentVerySatisfied!!
        }
        _sentimentVerySatisfied = materialIcon(name = "Rounded.SentimentVerySatisfied") {
            materialPath {
                moveTo(8.88f, 9.94f)
                lineToRelative(0.53f, 0.53f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                lineToRelative(-0.88f, -0.88f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-0.89f, 0.88f)
                curveToRelative(-0.29f, 0.29f, -0.29f, 0.77f, 0.0f, 1.06f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(0.53f, -0.53f)
                close()
                moveTo(12.0f, 17.5f)
                curveToRelative(2.03f, 0.0f, 3.8f, -1.11f, 4.75f, -2.75f)
                curveToRelative(0.19f, -0.33f, -0.05f, -0.75f, -0.44f, -0.75f)
                lineTo(7.69f, 14.0f)
                curveToRelative(-0.38f, 0.0f, -0.63f, 0.42f, -0.44f, 0.75f)
                curveToRelative(0.95f, 1.64f, 2.72f, 2.75f, 4.75f, 2.75f)
                close()
                moveTo(13.53f, 10.47f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                lineToRelative(0.53f, -0.53f)
                lineToRelative(0.53f, 0.53f)
                curveToRelative(0.29f, 0.29f, 0.77f, 0.29f, 1.06f, 0.0f)
                curveToRelative(0.29f, -0.29f, 0.29f, -0.77f, 0.0f, -1.06f)
                lineToRelative(-0.88f, -0.88f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-0.88f, 0.88f)
                curveToRelative(-0.3f, 0.29f, -0.3f, 0.77f, -0.01f, 1.06f)
                close()
                moveTo(11.99f, 2.0f)
                curveTo(6.47f, 2.0f, 2.0f, 6.47f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.47f, 10.0f, 9.99f, 10.0f)
                reflectiveCurveTo(22.0f, 17.53f, 22.0f, 12.0f)
                reflectiveCurveTo(17.52f, 2.0f, 11.99f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, -3.58f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.58f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveToRelative(-3.58f, 8.0f, -8.0f, 8.0f)
                close()
            }
        }
        return _sentimentVerySatisfied!!
    }

private var _sentimentVerySatisfied: ImageVector? = null
