/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SwapCalls: ImageVector
    get() {
        if (_swapCalls != null) {
            return _swapCalls!!
        }
        _swapCalls = materialIcon(name = "Rounded.SwapCalls") {
            materialPath {
                moveTo(17.65f, 4.35f)
                lineToRelative(-2.79f, 2.79f)
                curveToRelative(-0.32f, 0.32f, -0.1f, 0.86f, 0.35f, 0.86f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(6.88f)
                curveToRelative(0.0f, 1.0f, -0.67f, 1.93f, -1.66f, 2.09f)
                curveToRelative(-1.25f, 0.21f, -2.34f, -0.76f, -2.34f, -1.97f)
                verticalLineTo(8.17f)
                curveToRelative(0.0f, -2.09f, -1.53f, -3.95f, -3.61f, -4.15f)
                curveTo(7.01f, 3.79f, 5.0f, 5.66f, 5.0f, 8.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(3.21f)
                curveToRelative(-0.45f, 0.0f, -0.67f, 0.54f, -0.35f, 0.85f)
                lineToRelative(2.79f, 2.79f)
                curveToRelative(0.2f, 0.2f, 0.51f, 0.2f, 0.71f, 0.0f)
                lineToRelative(2.79f, -2.79f)
                curveToRelative(0.31f, -0.31f, 0.09f, -0.85f, -0.36f, -0.85f)
                horizontalLineTo(7.0f)
                verticalLineTo(8.12f)
                curveToRelative(0.0f, -1.0f, 0.67f, -1.93f, 1.66f, -2.09f)
                curveTo(9.91f, 5.82f, 11.0f, 6.79f, 11.0f, 8.0f)
                verticalLineToRelative(6.83f)
                curveToRelative(0.0f, 2.09f, 1.53f, 3.95f, 3.61f, 4.15f)
                curveTo(16.99f, 19.21f, 19.0f, 17.34f, 19.0f, 15.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.79f)
                curveToRelative(0.45f, 0.0f, 0.67f, -0.54f, 0.35f, -0.85f)
                lineToRelative(-2.79f, -2.79f)
                curveToRelative(-0.19f, -0.2f, -0.51f, -0.2f, -0.7f, -0.01f)
                close()
            }
        }
        return _swapCalls!!
    }

private var _swapCalls: ImageVector? = null
