/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Sharp.LabelOff: ImageVector
    get() {
        if (_labelOff != null) {
            return _labelOff!!
        }
        _labelOff = materialIcon(name = "AutoMirrored.Sharp.LabelOff", autoMirror = true) {
            materialPath {
                moveTo(22.0f, 12.0f)
                lineToRelative(-4.97f, -7.0f)
                horizontalLineTo(8.66f)
                lineToRelative(10.7f, 10.73f)
                close()
                moveTo(2.0f, 4.0f)
                lineToRelative(1.0f, 1.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(14.0f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.44f, 2.62f)
                close()
            }
        }
        return _labelOff!!
    }

private var _labelOff: ImageVector? = null
