/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DinnerDining: ImageVector
    get() {
        if (_dinnerDining != null) {
            return _dinnerDining!!
        }
        _dinnerDining = materialIcon(name = "Filled.DinnerDining") {
            materialPath {
                moveTo(2.0f, 19.0f)
                horizontalLineToRelative(20.0f)
                lineToRelative(-2.0f, 2.0f)
                horizontalLineTo(4.0f)
                lineTo(2.0f, 19.0f)
                close()
                moveTo(5.0f, 6.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(5.0f, 4.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(9.0f, 4.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(9.0f)
                close()
                moveTo(9.0f, 7.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(6.0f, 15.23f)
                curveToRelative(-0.36f, 0.11f, -0.69f, 0.28f, -1.0f, 0.47f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(15.23f)
                close()
                moveTo(4.0f, 16.52f)
                curveTo(3.62f, 16.96f, 3.32f, 17.45f, 3.16f, 18.0f)
                horizontalLineToRelative(16.82f)
                curveToRelative(0.01f, -0.16f, 0.03f, -0.33f, 0.03f, -0.5f)
                curveToRelative(0.0f, -3.04f, -2.46f, -5.5f, -5.5f, -5.5f)
                curveToRelative(-2.29f, 0.0f, -4.25f, 1.4f, -5.08f, 3.4f)
                curveTo(8.84f, 15.15f, 8.19f, 15.0f, 7.5f, 15.0f)
                curveToRelative(-0.17f, 0.0f, -0.33f, 0.02f, -0.5f, 0.04f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.03f, 0.06f, 1.9f, -0.96f, 2.0f, -2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(11.0f)
                curveToRelative(-0.1f, -1.05f, -0.97f, -1.97f, -2.0f, -2.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(16.52f)
                close()
            }
        }
        return _dinnerDining!!
    }

private var _dinnerDining: ImageVector? = null
