/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DesktopAccessDisabled: ImageVector
    get() {
        if (_desktopAccessDisabled != null) {
            return _desktopAccessDisabled!!
        }
        _desktopAccessDisabled = materialIcon(name = "Outlined.DesktopAccessDisabled") {
            materialPath {
                moveTo(1.41f, 1.69f)
                lineTo(0.0f, 3.1f)
                lineToRelative(1.0f, 0.99f)
                verticalLineTo(16.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 1.99f, 2.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(0.9f)
                lineToRelative(6.0f, 6.0f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-20.9f, -20.9f)
                close()
                moveTo(2.99f, 16.0f)
                verticalLineTo(6.09f)
                lineTo(12.9f, 16.0f)
                horizontalLineTo(2.99f)
                close()
                moveTo(4.55f, 2.0f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(-2.45f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(0.44f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.55f)
                close()
            }
        }
        return _desktopAccessDisabled!!
    }

private var _desktopAccessDisabled: ImageVector? = null
