/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.EarbudsBattery: ImageVector
    get() {
        if (_earbudsBattery != null) {
            return _earbudsBattery!!
        }
        _earbudsBattery = materialIcon(name = "Rounded.EarbudsBattery") {
            materialPath {
                moveTo(21.0f, 7.0f)
                horizontalLineToRelative(-1.0f)
                lineToRelative(0.0f, 0.0f)
                verticalLineTo(6.5f)
                curveTo(20.0f, 6.22f, 19.78f, 6.0f, 19.5f, 6.0f)
                lineToRelative(-1.0f, 0.0f)
                curveTo(18.22f, 6.0f, 18.0f, 6.22f, 18.0f, 6.5f)
                verticalLineTo(7.0f)
                lineToRelative(0.0f, 0.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(8.0f)
                curveTo(22.0f, 7.45f, 21.55f, 7.0f, 21.0f, 7.0f)
                close()
                moveTo(14.0f, 9.38f)
                curveTo(14.0f, 7.51f, 12.49f, 6.0f, 10.62f, 6.0f)
                reflectiveCurveTo(7.25f, 7.51f, 7.25f, 9.38f)
                verticalLineToRelative(5.25f)
                curveToRelative(0.0f, 1.04f, -0.84f, 1.88f, -1.88f, 1.88f)
                reflectiveCurveTo(3.5f, 15.66f, 3.5f, 14.62f)
                verticalLineToRelative(-4.7f)
                curveTo(3.66f, 9.97f, 3.83f, 10.0f, 4.0f, 10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(5.1f, 6.0f, 4.0f, 6.0f)
                reflectiveCurveTo(2.0f, 6.9f, 2.0f, 8.0f)
                curveToRelative(0.0f, 0.04f, 0.0f, 6.62f, 0.0f, 6.62f)
                curveTo(2.0f, 16.49f, 3.51f, 18.0f, 5.38f, 18.0f)
                reflectiveCurveToRelative(3.38f, -1.51f, 3.38f, -3.38f)
                verticalLineTo(9.38f)
                curveToRelative(0.0f, -1.04f, 0.84f, -1.88f, 1.88f, -1.88f)
                reflectiveCurveToRelative(1.88f, 0.84f, 1.88f, 1.88f)
                verticalLineToRelative(4.7f)
                curveTo(12.34f, 14.03f, 12.17f, 14.0f, 12.0f, 14.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                curveTo(14.0f, 15.96f, 14.0f, 9.38f, 14.0f, 9.38f)
                close()
            }
        }
        return _earbudsBattery!!
    }

private var _earbudsBattery: ImageVector? = null
