/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HowToVote: ImageVector
    get() {
        if (_howToVote != null) {
            return _howToVote!!
        }
        _howToVote = materialIcon(name = "Rounded.HowToVote") {
            materialPath {
                moveTo(18.0f, 12.18f)
                lineToRelative(-1.5f, 1.64f)
                lineToRelative(2.0f, 2.18f)
                horizontalLineToRelative(-13.0f)
                lineToRelative(2.0f, -2.18f)
                lineTo(6.0f, 12.18f)
                lineToRelative(-3.0f, 3.27f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.54f)
                lineTo(18.0f, 12.18f)
                close()
            }
            materialPath {
                moveTo(10.59f, 14.42f)
                curveToRelative(0.78f, 0.79f, 2.05f, 0.8f, 2.84f, 0.01f)
                lineToRelative(4.98f, -4.98f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-3.54f, -3.53f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineTo(7.09f, 8.04f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.03f, -0.01f, 2.82f)
                lineTo(10.59f, 14.42f)
                close()
                moveTo(13.46f, 4.5f)
                lineToRelative(3.53f, 3.53f)
                lineToRelative(-4.94f, 4.94f)
                lineTo(8.52f, 9.44f)
                lineTo(13.46f, 4.5f)
                close()
            }
        }
        return _howToVote!!
    }

private var _howToVote: ImageVector? = null
