/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SignalWifiStatusbarConnectedNoInternet4: ImageVector
    get() {
        if (_signalWifiStatusbarConnectedNoInternet4 != null) {
            return _signalWifiStatusbarConnectedNoInternet4!!
        }
        _signalWifiStatusbarConnectedNoInternet4 = materialIcon(name =
                "Sharp.SignalWifiStatusbarConnectedNoInternet4") {
            materialPath {
                moveTo(19.0f, 18.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                curveTo(7.31f, 4.0f, 3.07f, 5.9f, 0.0f, 8.98f)
                lineTo(12.0f, 21.0f)
                lineToRelative(5.0f, -5.01f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(5.92f)
                curveTo(19.97f, 5.51f, 16.16f, 4.0f, 12.0f, 4.0f)
                close()
            }
        }
        return _signalWifiStatusbarConnectedNoInternet4!!
    }

private var _signalWifiStatusbarConnectedNoInternet4: ImageVector? = null
