/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.ripple;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.AnimationUtils;
import androidx.compose.foundation.interaction.PressInteraction;
import androidx.compose.material.ripple.UnprojectedRipple;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.RectHelper_androidKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JQ\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010 \u001a\u00020\rJ\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0018H\u0014J\u0018\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0018H\u0014J\b\u0010-\u001a\u00020\rH\u0016J\u0006\u0010.\u001a\u00020\rJ\u0010\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0006H\u0002J3\u00101\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b2\u00103R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00065"}, d2={"Landroidx/compose/material/ripple/RippleHostView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bounded", "", "Ljava/lang/Boolean;", "lastRippleStateChangeTimeMillis", "", "Ljava/lang/Long;", "onInvalidateRipple", "Lkotlin/Function0;", "", "resetRippleRunnable", "Ljava/lang/Runnable;", "ripple", "Landroidx/compose/material/ripple/UnprojectedRipple;", "addRipple", "interaction", "Landroidx/compose/foundation/interaction/PressInteraction$Press;", "size", "Landroidx/compose/ui/geometry/Size;", "radius", "", "color", "Landroidx/compose/ui/graphics/Color;", "alpha", "", "addRipple-KOepWvA", "(Landroidx/compose/foundation/interaction/PressInteraction$Press;ZJIJFLkotlin/jvm/functions/Function0;)V", "createRipple", "disposeRipple", "invalidateDrawable", "who", "Landroid/graphics/drawable/Drawable;", "onLayout", "changed", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "refreshDrawableState", "removeRipple", "setRippleState", "pressed", "updateRippleProperties", "updateRippleProperties-biQXAtU", "(JIJF)V", "Companion", "material-ripple_release"})
public final class RippleHostView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UnprojectedRipple ripple;
    @Nullable
    private Boolean bounded;
    @Nullable
    private Long lastRippleStateChangeTimeMillis;
    @Nullable
    private Runnable resetRippleRunnable;
    @Nullable
    private Function0<Unit> onInvalidateRipple;
    private static final long MinimumRippleStateChangeTime = 5L;
    private static final long ResetRippleDelayDuration = 50L;
    @NotNull
    private static final int[] PressedState;
    @NotNull
    private static final int[] RestingState;

    public RippleHostView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public void refreshDrawableState() {
    }

    /*
     * WARNING - void declaration
     */
    private final void createRipple(boolean bounded) {
        void $this$createRipple_u24lambda_u2d0;
        UnprojectedRipple unprojectedRipple;
        UnprojectedRipple unprojectedRipple2 = unprojectedRipple = new UnprojectedRipple(bounded);
        RippleHostView rippleHostView = this;
        boolean bl = false;
        this.setBackground((Drawable)$this$createRipple_u24lambda_u2d0);
        rippleHostView.ripple = unprojectedRipple;
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Function0<Unit> function0 = this.onInvalidateRipple;
        if (function0 != null) {
            function0.invoke();
        }
    }

    public final void addRipple-KOepWvA(@NotNull PressInteraction.Press interaction, boolean bounded, long size, int radius, long color, float alpha, @NotNull Function0<Unit> onInvalidateRipple2) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(onInvalidateRipple2, (String)"onInvalidateRipple");
        if (this.ripple == null || !Intrinsics.areEqual((Object)bounded, (Object)this.bounded)) {
            this.createRipple(bounded);
            this.bounded = bounded;
        }
        UnprojectedRipple unprojectedRipple = this.ripple;
        Intrinsics.checkNotNull((Object)((Object)unprojectedRipple));
        UnprojectedRipple ripple = unprojectedRipple;
        this.onInvalidateRipple = onInvalidateRipple2;
        this.updateRippleProperties-biQXAtU(size, radius, color, alpha);
        if (bounded) {
            ripple.setHotspot(Offset.getX-impl((long)interaction.getPressPosition-F1C5BW0()), Offset.getY-impl((long)interaction.getPressPosition-F1C5BW0()));
        } else {
            ripple.setHotspot(ripple.getBounds().centerX(), ripple.getBounds().centerY());
        }
        this.setRippleState(true);
    }

    public final void removeRipple() {
        this.setRippleState(false);
    }

    public final void updateRippleProperties-biQXAtU(long size, int radius, long color, float alpha) {
        UnprojectedRipple unprojectedRipple = this.ripple;
        if (unprojectedRipple == null) {
            return;
        }
        UnprojectedRipple ripple = unprojectedRipple;
        ripple.trySetRadius(radius);
        ripple.setColor-DxMtmZc(color, alpha);
        android.graphics.Rect newBounds = RectHelper_androidKt.toAndroidRect((Rect)SizeKt.toRect-uvyYCjk((long)size));
        this.setLeft(newBounds.left);
        this.setTop(newBounds.top);
        this.setRight(newBounds.right);
        this.setBottom(newBounds.bottom);
        ripple.setBounds(newBounds);
    }

    public final void disposeRipple() {
        this.onInvalidateRipple = null;
        if (this.resetRippleRunnable != null) {
            this.removeCallbacks(this.resetRippleRunnable);
            Runnable runnable = this.resetRippleRunnable;
            Intrinsics.checkNotNull((Object)runnable);
            runnable.run();
        } else {
            UnprojectedRipple unprojectedRipple = this.ripple;
            if (unprojectedRipple != null) {
                unprojectedRipple.setState(RestingState);
            }
        }
        UnprojectedRipple unprojectedRipple = this.ripple;
        if (unprojectedRipple == null) {
            return;
        }
        UnprojectedRipple ripple = unprojectedRipple;
        ripple.setVisible(false, false);
        this.unscheduleDrawable((Drawable)ripple);
    }

    private final void setRippleState(boolean pressed) {
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        Runnable runnable = this.resetRippleRunnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            this.removeCallbacks(runnable2);
            runnable2.run();
        }
        Long l = this.lastRippleStateChangeTimeMillis;
        long timeSinceLastStateChange = currentTime - (l == null ? 0L : l);
        if (!pressed && timeSinceLastStateChange < 5L) {
            this.resetRippleRunnable = () -> RippleHostView.setRippleState$lambda-2(this);
            this.postDelayed(this.resetRippleRunnable, 50L);
        } else {
            int[] state = pressed ? PressedState : RestingState;
            UnprojectedRipple unprojectedRipple = this.ripple;
            if (unprojectedRipple != null) {
                unprojectedRipple.setState(state);
            }
        }
        this.lastRippleStateChangeTimeMillis = currentTime;
    }

    private static final void setRippleState$lambda-2(RippleHostView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        UnprojectedRipple unprojectedRipple = this$0.ripple;
        if (unprojectedRipple != null) {
            unprojectedRipple.setState(RestingState);
        }
        this$0.resetRippleRunnable = null;
    }

    static {
        int[] nArray = new int[]{16842919, 16842910};
        PressedState = nArray;
        RestingState = new int[0];
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/compose/material/ripple/RippleHostView$Companion;", "", "()V", "MinimumRippleStateChangeTime", "", "PressedState", "", "ResetRippleDelayDuration", "RestingState", "material-ripple_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

