/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4;

import androidx.compose.runtime.Recomposer;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.ui.platform.ViewRootForTest;
import androidx.compose.ui.test.IdlingResource;
import androidx.compose.ui.test.junit4.ComposeIdlingResource_androidKt;
import androidx.compose.ui.test.junit4.ComposeRootRegistry;
import androidx.compose.ui.test.junit4.MainTestClockImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/test/junit4/ComposeIdlingResource;", "Landroidx/compose/ui/test/IdlingResource;", "composeRootRegistry", "Landroidx/compose/ui/test/junit4/ComposeRootRegistry;", "clock", "Landroidx/compose/ui/test/junit4/MainTestClockImpl;", "mainRecomposer", "Landroidx/compose/runtime/Recomposer;", "(Landroidx/compose/ui/test/junit4/ComposeRootRegistry;Landroidx/compose/ui/test/junit4/MainTestClockImpl;Landroidx/compose/runtime/Recomposer;)V", "hadAwaitersOnMainClock", "", "hadPendingMeasureLayout", "hadPendingSetContent", "hadRecomposerChanges", "hadSnapshotChanges", "isIdleNow", "()Z", "getDiagnosticMessageIfBusy", "", "ui-test-junit4_release"})
public final class ComposeIdlingResource
implements IdlingResource {
    @NotNull
    private final ComposeRootRegistry composeRootRegistry;
    @NotNull
    private final MainTestClockImpl clock;
    @NotNull
    private final Recomposer mainRecomposer;
    private boolean hadAwaitersOnMainClock;
    private boolean hadSnapshotChanges;
    private boolean hadRecomposerChanges;
    private boolean hadPendingSetContent;
    private boolean hadPendingMeasureLayout;

    public ComposeIdlingResource(@NotNull ComposeRootRegistry composeRootRegistry, @NotNull MainTestClockImpl clock, @NotNull Recomposer mainRecomposer) {
        Intrinsics.checkNotNullParameter((Object)composeRootRegistry, (String)"composeRootRegistry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mainRecomposer, (String)"mainRecomposer");
        this.composeRootRegistry = composeRootRegistry;
        this.clock = clock;
        this.mainRecomposer = mainRecomposer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isIdleNow() {
        boolean bl;
        boolean bl2;
        block8: {
            void $this$any$iv;
            boolean bl3;
            ComposeIdlingResource composeIdlingResource;
            block7: {
                void $this$any$iv2;
                for (int i = 0; i < 100 && ComposeIdlingResource._get_isIdleNow_$shouldPumpTime(this); ++i) {
                    this.clock.advanceTimeByFrame();
                }
                Iterable iterable = this.composeRootRegistry.getCreatedComposeRoots();
                composeIdlingResource = this;
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        ViewRootForTest it = (ViewRootForTest)element$iv;
                        boolean bl4 = false;
                        if (!ComposeIdlingResource_androidKt.access$isBusyAttaching(it)) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
            }
            composeIdlingResource.hadPendingSetContent = bl2 = bl3;
            Set<ViewRootForTest> composeRoots = this.composeRootRegistry.getRegisteredComposeRoots();
            Iterable $i$f$any = composeRoots;
            composeIdlingResource = this;
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ViewRootForTest it = (ViewRootForTest)element$iv;
                    boolean bl5 = false;
                    if (!ComposeIdlingResource_androidKt.getShouldWaitForMeasureAndLayout(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        composeIdlingResource.hadPendingMeasureLayout = bl2 = bl;
        return !ComposeIdlingResource._get_isIdleNow_$shouldPumpTime(this) && !this.hadPendingSetContent && !this.hadPendingMeasureLayout;
    }

    @Nullable
    public String getDiagnosticMessageIfBusy() {
        boolean busyRecomposing;
        boolean wasBusy;
        boolean bl = wasBusy = this.hadSnapshotChanges || this.hadRecomposerChanges || this.hadAwaitersOnMainClock || this.hadPendingSetContent || this.hadPendingMeasureLayout;
        if (!wasBusy) {
            return null;
        }
        List busyReasons = new ArrayList();
        boolean bl2 = busyRecomposing = this.hadSnapshotChanges || this.hadRecomposerChanges || this.hadAwaitersOnMainClock;
        if (busyRecomposing) {
            busyReasons.add("pending recompositions");
        }
        if (this.hadPendingSetContent) {
            busyReasons.add("pending setContent");
        }
        if (this.hadPendingMeasureLayout) {
            busyReasons.add("pending measure/layout");
        }
        String message = this.getClass().getSimpleName() + " is busy due to " + CollectionsKt.joinToString$default((Iterable)busyReasons, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ".\n";
        if (busyRecomposing) {
            message = message + "- Note: Timeout on pending recomposition means that there are most likely infinite re-compositions happening in the tested code.\n";
            message = message + "- Debug: hadRecomposerChanges = " + this.hadRecomposerChanges + ", ";
            message = message + "hadSnapshotChanges = " + this.hadSnapshotChanges + ", ";
            message = message + "hadAwaitersOnMainClock = " + this.hadAwaitersOnMainClock;
        }
        return message;
    }

    private static final boolean _get_isIdleNow_$shouldPumpTime(ComposeIdlingResource this$0) {
        this$0.hadAwaitersOnMainClock = this$0.clock.getHasAwaiters$ui_test_junit4_release();
        this$0.hadSnapshotChanges = Snapshot.Companion.getCurrent().hasPendingChanges();
        this$0.hadRecomposerChanges = this$0.mainRecomposer.getHasPendingWork();
        boolean needsRecompose = this$0.hadAwaitersOnMainClock || this$0.hadSnapshotChanges || this$0.hadRecomposerChanges;
        return this$0.clock.getAutoAdvance() && needsRecompose;
    }
}

