/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.unit.fontscaling;

import androidx.annotation.AnyThread;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.InlineClassHelperKt;
import androidx.compose.ui.unit.fontscaling.FontScaleConverter;
import androidx.compose.ui.unit.fontscaling.FontScaleConverterTable;
import androidx.compose.ui.unit.fontscaling.MathUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0007H\u0082\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\nH\u0002J&\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\nH\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/compose/ui/unit/fontscaling/FontScaleConverterFactory;", "", "()V", "LOOKUP_TABLES_WRITE_LOCK", "", "[Ljava/lang/Object;", "SCALE_KEY_MULTIPLIER", "", "sLookupTables", "Landroidx/collection/SparseArrayCompat;", "Landroidx/compose/ui/unit/fontscaling/FontScaleConverter;", "getSLookupTables$annotations", "getSLookupTables", "()Landroidx/collection/SparseArrayCompat;", "setSLookupTables", "(Landroidx/collection/SparseArrayCompat;)V", "sMinScaleBeforeCurvesApplied", "createInterpolatedTableBetween", "start", "end", "interpolationPoint", "forScale", "fontScale", "get", "scaleKey", "getKey", "", "getScaleFromKey", "key", "isNonLinearFontScalingActive", "", "put", "", "fontScaleConverter", "putInto", "table", "ui-unit_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFontScaleConverterFactory.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontScaleConverterFactory.android.kt\nandroidx/compose/ui/unit/fontscaling/FontScaleConverterFactory\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/unit/InlineClassHelperKt\n*L\n1#1,224:1\n57#2,7:225\n*S KotlinDebug\n*F\n+ 1 FontScaleConverterFactory.android.kt\nandroidx/compose/ui/unit/fontscaling/FontScaleConverterFactory\n*L\n97#1:225,7\n*E\n"})
public final class FontScaleConverterFactory {
    @NotNull
    public static final FontScaleConverterFactory INSTANCE = new FontScaleConverterFactory();
    private static final float SCALE_KEY_MULTIPLIER = 100.0f;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private static volatile SparseArrayCompat<FontScaleConverter> sLookupTables = new SparseArrayCompat(0, 1, null);
    @NotNull
    private static final Object[] LOOKUP_TABLES_WRITE_LOCK = new Object[0];
    private static float sMinScaleBeforeCurvesApplied = 1.05f;
    public static final int $stable;

    private FontScaleConverterFactory() {
    }

    @NotNull
    public final SparseArrayCompat<FontScaleConverter> getSLookupTables() {
        return sLookupTables;
    }

    public final void setSLookupTables(@NotNull SparseArrayCompat<FontScaleConverter> sparseArrayCompat) {
        sLookupTables = sparseArrayCompat;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSLookupTables$annotations() {
    }

    @AnyThread
    public final boolean isNonLinearFontScalingActive(float fontScale) {
        return fontScale >= sMinScaleBeforeCurvesApplied;
    }

    @AnyThread
    @Nullable
    public final FontScaleConverter forScale(float fontScale) {
        FontScaleConverter fontScaleConverter;
        if (!this.isNonLinearFontScalingActive(fontScale)) {
            return null;
        }
        FontScaleConverter lookupTable = INSTANCE.get(fontScale);
        if (lookupTable != null) {
            return lookupTable;
        }
        int index = sLookupTables.indexOfKey(this.getKey(fontScale));
        if (index >= 0) {
            return (FontScaleConverter)sLookupTables.valueAt(index);
        }
        int lowerIndex = -(index + 1) - 1;
        int higherIndex = lowerIndex + 1;
        if (lowerIndex < 0 || higherIndex >= sLookupTables.size()) {
            float[] fArray = new float[]{1.0f};
            float[] fArray2 = fArray;
            fArray = new float[]{fontScale};
            FontScaleConverterTable converter = new FontScaleConverterTable(fArray2, fArray);
            this.put(fontScale, converter);
            fontScaleConverter = converter;
        } else {
            float startScale = this.getScaleFromKey(sLookupTables.keyAt(lowerIndex));
            float endScale = this.getScaleFromKey(sLookupTables.keyAt(higherIndex));
            float interpolationPoint = MathUtils.INSTANCE.constrainedMap(0.0f, 1.0f, startScale, endScale, fontScale);
            FontScaleConverter converter = this.createInterpolatedTableBetween((FontScaleConverter)sLookupTables.valueAt(lowerIndex), (FontScaleConverter)sLookupTables.valueAt(higherIndex), interpolationPoint);
            this.put(fontScale, converter);
            fontScaleConverter = converter;
        }
        return fontScaleConverter;
    }

    private final FontScaleConverter createInterpolatedTableBetween(FontScaleConverter start, FontScaleConverter end, float interpolationPoint) {
        float[] fArray = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
        float[] commonSpSizes = fArray;
        float[] dpInterpolated = new float[commonSpSizes.length];
        int n = commonSpSizes.length;
        for (int i = 0; i < n; ++i) {
            float sp = commonSpSizes[i];
            float startDp = start.convertSpToDp(sp);
            float endDp = end.convertSpToDp(sp);
            dpInterpolated[i] = MathUtils.INSTANCE.lerp(startDp, endDp, interpolationPoint);
        }
        return new FontScaleConverterTable(commonSpSizes, dpInterpolated);
    }

    private final int getKey(float fontScale) {
        return (int)(fontScale * 100.0f);
    }

    private final float getScaleFromKey(int key) {
        return (float)key / 100.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void put(float scaleKey, FontScaleConverter fontScaleConverter) {
        Object[] objectArray = LOOKUP_TABLES_WRITE_LOCK;
        synchronized (objectArray) {
            boolean bl = false;
            SparseArrayCompat newTable = sLookupTables.clone();
            INSTANCE.putInto((SparseArrayCompat<FontScaleConverter>)newTable, scaleKey, fontScaleConverter);
            sLookupTables = newTable;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void putInto(SparseArrayCompat<FontScaleConverter> table, float scaleKey, FontScaleConverter fontScaleConverter) {
        table.put(this.getKey(scaleKey), (Object)fontScaleConverter);
    }

    private final FontScaleConverter get(float scaleKey) {
        return (FontScaleConverter)sLookupTables.get(this.getKey(scaleKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object[] objectArray = LOOKUP_TABLES_WRITE_LOCK;
        synchronized (objectArray) {
            boolean $i$a$-synchronized-FontScaleConverterFactory$22 = false;
            float[] fArray = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
            float[] fArray2 = fArray;
            fArray = new float[]{9.2f, 11.5f, 13.8f, 16.4f, 19.8f, 21.8f, 25.2f, 30.0f, 100.0f};
            INSTANCE.putInto(sLookupTables, 1.15f, new FontScaleConverterTable(fArray2, fArray));
            fArray = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
            float[] fArray3 = fArray;
            fArray = new float[]{10.4f, 13.0f, 15.6f, 18.8f, 21.6f, 23.6f, 26.4f, 30.0f, 100.0f};
            INSTANCE.putInto(sLookupTables, 1.3f, new FontScaleConverterTable(fArray3, fArray));
            fArray = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
            float[] fArray4 = fArray;
            fArray = new float[]{12.0f, 15.0f, 18.0f, 22.0f, 24.0f, 26.0f, 28.0f, 30.0f, 100.0f};
            INSTANCE.putInto(sLookupTables, 1.5f, new FontScaleConverterTable(fArray4, fArray));
            fArray = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
            float[] fArray5 = fArray;
            fArray = new float[]{14.4f, 18.0f, 21.6f, 24.4f, 27.6f, 30.8f, 32.8f, 34.8f, 100.0f};
            INSTANCE.putInto(sLookupTables, 1.8f, new FontScaleConverterTable(fArray5, fArray));
            fArray = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
            float[] fArray6 = fArray;
            fArray = new float[]{16.0f, 20.0f, 24.0f, 26.0f, 30.0f, 34.0f, 36.0f, 38.0f, 100.0f};
            INSTANCE.putInto(sLookupTables, 2.0f, new FontScaleConverterTable(fArray6, fArray));
            Unit $i$a$-synchronized-FontScaleConverterFactory$22 = Unit.INSTANCE;
        }
        sMinScaleBeforeCurvesApplied = INSTANCE.getScaleFromKey(sLookupTables.keyAt(0)) - 0.02f;
        boolean value$iv = sMinScaleBeforeCurvesApplied > 1.0f;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("You should only apply non-linear scaling to font scales > 1");
        }
        $stable = 8;
    }
}

