/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;

public class CLToken
extends CLElement {
    int index = 0;
    Type type = Type.UNKNOWN;
    char[] tokenTrue = "true".toCharArray();
    char[] tokenFalse = "false".toCharArray();
    char[] tokenNull = "null".toCharArray();

    public boolean getBoolean() throws CLParsingException {
        if (this.type == Type.TRUE) {
            return true;
        }
        if (this.type == Type.FALSE) {
            return false;
        }
        throw new CLParsingException("this token is not a boolean: <" + this.content() + ">", this);
    }

    public boolean isNull() throws CLParsingException {
        if (this.type == Type.NULL) {
            return true;
        }
        throw new CLParsingException("this token is not a null: <" + this.content() + ">", this);
    }

    public CLToken(char[] content) {
        super(content);
    }

    public static CLElement allocate(char[] content) {
        return new CLToken(content);
    }

    @Override
    protected String toJSON() {
        if (CLParser.DEBUG) {
            return "<" + this.content() + ">";
        }
        return this.content();
    }

    @Override
    protected String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder();
        this.addIndent(json, indent);
        json.append(this.content());
        return json.toString();
    }

    public Type getType() {
        return this.type;
    }

    public boolean validate(char c, long position) {
        boolean isValid = false;
        switch (this.type) {
            case TRUE: {
                boolean bl = isValid = this.tokenTrue[this.index] == c;
                if (!isValid || this.index + 1 != this.tokenTrue.length) break;
                this.setEnd(position);
                break;
            }
            case FALSE: {
                boolean bl = isValid = this.tokenFalse[this.index] == c;
                if (!isValid || this.index + 1 != this.tokenFalse.length) break;
                this.setEnd(position);
                break;
            }
            case NULL: {
                boolean bl = isValid = this.tokenNull[this.index] == c;
                if (!isValid || this.index + 1 != this.tokenNull.length) break;
                this.setEnd(position);
                break;
            }
            case UNKNOWN: {
                if (this.tokenTrue[this.index] == c) {
                    this.type = Type.TRUE;
                    isValid = true;
                    break;
                }
                if (this.tokenFalse[this.index] == c) {
                    this.type = Type.FALSE;
                    isValid = true;
                    break;
                }
                if (this.tokenNull[this.index] != c) break;
                this.type = Type.NULL;
                isValid = true;
            }
        }
        ++this.index;
        return isValid;
    }

    static enum Type {
        UNKNOWN,
        TRUE,
        FALSE,
        NULL;

    }
}

