/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DependencyNode
implements Dependency {
    public Dependency updateDelegate = null;
    public boolean delegateToWidgetRun = false;
    public boolean readyToSolve = false;
    WidgetRun mRun;
    Type mType = Type.UNKNOWN;
    int mMargin;
    public int value;
    int mMarginFactor = 1;
    DimensionDependency mMarginDependency = null;
    public boolean resolved = false;
    List<Dependency> mDependencies = new ArrayList<Dependency>();
    List<DependencyNode> mTargets = new ArrayList<DependencyNode>();

    public DependencyNode(WidgetRun run) {
        this.mRun = run;
    }

    public String toString() {
        return this.mRun.mWidget.getDebugName() + ":" + this.mType + "(" + (Serializable)(this.resolved ? Integer.valueOf(this.value) : "unresolved") + ") <t=" + this.mTargets.size() + ":d=" + this.mDependencies.size() + ">";
    }

    public void resolve(int value) {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.value = value;
        for (Dependency node : this.mDependencies) {
            node.update(node);
        }
    }

    @Override
    public void update(Dependency node) {
        for (DependencyNode target : this.mTargets) {
            if (target.resolved) continue;
            return;
        }
        this.readyToSolve = true;
        if (this.updateDelegate != null) {
            this.updateDelegate.update(this);
        }
        if (this.delegateToWidgetRun) {
            this.mRun.update(this);
            return;
        }
        DependencyNode target = null;
        int numTargets = 0;
        for (DependencyNode t : this.mTargets) {
            if (t instanceof DimensionDependency) continue;
            target = t;
            ++numTargets;
        }
        if (target != null && numTargets == 1 && target.resolved) {
            if (this.mMarginDependency != null) {
                if (this.mMarginDependency.resolved) {
                    this.mMargin = this.mMarginFactor * this.mMarginDependency.value;
                } else {
                    return;
                }
            }
            this.resolve(target.value + this.mMargin);
        }
        if (this.updateDelegate != null) {
            this.updateDelegate.update(this);
        }
    }

    public void addDependency(Dependency dependency) {
        this.mDependencies.add(dependency);
        if (this.resolved) {
            dependency.update(dependency);
        }
    }

    public String name() {
        Object definition = this.mRun.mWidget.getDebugName();
        definition = this.mType == Type.LEFT || this.mType == Type.RIGHT ? (String)definition + "_HORIZONTAL" : (String)definition + "_VERTICAL";
        definition = (String)definition + ":" + this.mType.name();
        return definition;
    }

    public void clear() {
        this.mTargets.clear();
        this.mDependencies.clear();
        this.resolved = false;
        this.value = 0;
        this.readyToSolve = false;
        this.delegateToWidgetRun = false;
    }

    static enum Type {
        UNKNOWN,
        HORIZONTAL_DIMENSION,
        VERTICAL_DIMENSION,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        BASELINE;

    }
}

