/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.HashMap;
import java.util.HashSet;

public abstract class MotionKey
implements TypedValues {
    public static int UNSET = -1;
    public int mFramePosition = UNSET;
    int mTargetId = UNSET;
    String mTargetString = null;
    public int mType;
    public HashMap<String, CustomVariable> mCustom;
    public static final String ALPHA = "alpha";
    public static final String ELEVATION = "elevation";
    public static final String ROTATION = "rotationZ";
    public static final String ROTATION_X = "rotationX";
    public static final String TRANSITION_PATH_ROTATE = "transitionPathRotate";
    public static final String SCALE_X = "scaleX";
    public static final String SCALE_Y = "scaleY";
    public static final String TRANSLATION_X = "translationX";
    public static final String TRANSLATION_Y = "translationY";
    public static final String CUSTOM = "CUSTOM";
    public static final String VISIBILITY = "visibility";

    public abstract void getAttributeNames(HashSet<String> var1);

    boolean matches(String constraintTag) {
        if (this.mTargetString == null || constraintTag == null) {
            return false;
        }
        return constraintTag.matches(this.mTargetString);
    }

    public abstract void addValues(HashMap<String, SplineSet> var1);

    float toFloat(Object value) {
        return value instanceof Float ? ((Float)value).floatValue() : Float.parseFloat(value.toString());
    }

    int toInt(Object value) {
        return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
    }

    boolean toBoolean(Object value) {
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
    }

    public void setInterpolation(HashMap<String, Integer> interpolation) {
    }

    public MotionKey copy(MotionKey src) {
        this.mFramePosition = src.mFramePosition;
        this.mTargetId = src.mTargetId;
        this.mTargetString = src.mTargetString;
        this.mType = src.mType;
        return this;
    }

    public abstract MotionKey clone();

    public MotionKey setViewId(int id) {
        this.mTargetId = id;
        return this;
    }

    public void setFramePosition(int pos) {
        this.mFramePosition = pos;
    }

    public int getFramePosition() {
        return this.mFramePosition;
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 100: {
                this.mFramePosition = value;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setValue(int type, float value) {
        return false;
    }

    @Override
    public boolean setValue(int type, String value) {
        switch (type) {
            case 101: {
                this.mTargetString = value;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setValue(int type, boolean value) {
        return false;
    }

    public void setCustomAttribute(String name, int type, float value) {
        this.mCustom.put(name, new CustomVariable(name, type, value));
    }

    public void setCustomAttribute(String name, int type, int value) {
        this.mCustom.put(name, new CustomVariable(name, type, value));
    }

    public void setCustomAttribute(String name, int type, boolean value) {
        this.mCustom.put(name, new CustomVariable(name, type, value));
    }

    public void setCustomAttribute(String name, int type, String value) {
        this.mCustom.put(name, new CustomVariable(name, type, value));
    }
}

