/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.Schlick;
import androidx.constraintlayout.core.motion.utils.StepCurve;
import java.util.Arrays;

public class Easing {
    static Easing sDefault = new Easing();
    String mStr = "identity";
    private static final String STANDARD = "cubic(0.4, 0.0, 0.2, 1)";
    private static final String ACCELERATE = "cubic(0.4, 0.05, 0.8, 0.7)";
    private static final String DECELERATE = "cubic(0.0, 0.0, 0.2, 0.95)";
    private static final String LINEAR = "cubic(1, 1, 0, 0)";
    private static final String ANTICIPATE = "cubic(0.36, 0, 0.66, -0.56)";
    private static final String OVERSHOOT = "cubic(0.34, 1.56, 0.64, 1)";
    private static final String DECELERATE_NAME = "decelerate";
    private static final String ACCELERATE_NAME = "accelerate";
    private static final String STANDARD_NAME = "standard";
    private static final String LINEAR_NAME = "linear";
    private static final String ANTICIPATE_NAME = "anticipate";
    private static final String OVERSHOOT_NAME = "overshoot";
    public static String[] NAMED_EASING = new String[]{"standard", "accelerate", "decelerate", "linear"};

    public static Easing getInterpolator(String configString) {
        if (configString == null) {
            return null;
        }
        if (configString.startsWith("cubic")) {
            return new CubicEasing(configString);
        }
        if (configString.startsWith("spline")) {
            return new StepCurve(configString);
        }
        if (configString.startsWith("Schlick")) {
            return new Schlick(configString);
        }
        switch (configString) {
            case "standard": {
                return new CubicEasing(STANDARD);
            }
            case "accelerate": {
                return new CubicEasing(ACCELERATE);
            }
            case "decelerate": {
                return new CubicEasing(DECELERATE);
            }
            case "linear": {
                return new CubicEasing(LINEAR);
            }
            case "anticipate": {
                return new CubicEasing(ANTICIPATE);
            }
            case "overshoot": {
                return new CubicEasing(OVERSHOOT);
            }
        }
        System.err.println("transitionEasing syntax error syntax:transitionEasing=\"cubic(1.0,0.5,0.0,0.6)\" or " + Arrays.toString(NAMED_EASING));
        return sDefault;
    }

    public double get(double x) {
        return x;
    }

    public String toString() {
        return this.mStr;
    }

    public double getDiff(double x) {
        return 1.0;
    }

    static class CubicEasing
    extends Easing {
        private static double sError = 0.01;
        private static double sDError = 1.0E-4;
        double mX1;
        double mY1;
        double mX2;
        double mY2;

        CubicEasing(String configString) {
            this.mStr = configString;
            int start = configString.indexOf(40);
            int off1 = configString.indexOf(44, start);
            this.mX1 = Double.parseDouble(configString.substring(start + 1, off1).trim());
            int off2 = configString.indexOf(44, off1 + 1);
            this.mY1 = Double.parseDouble(configString.substring(off1 + 1, off2).trim());
            int off3 = configString.indexOf(44, off2 + 1);
            this.mX2 = Double.parseDouble(configString.substring(off2 + 1, off3).trim());
            int end = configString.indexOf(41, off3 + 1);
            this.mY2 = Double.parseDouble(configString.substring(off3 + 1, end).trim());
        }

        CubicEasing(double x1, double y1, double x2, double y2) {
            this.setup(x1, y1, x2, y2);
        }

        void setup(double x1, double y1, double x2, double y2) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
        }

        private double getX(double t) {
            double t1 = 1.0 - t;
            double f1 = 3.0 * t1 * t1 * t;
            double f2 = 3.0 * t1 * t * t;
            double f3 = t * t * t;
            return this.mX1 * f1 + this.mX2 * f2 + f3;
        }

        private double getY(double t) {
            double t1 = 1.0 - t;
            double f1 = 3.0 * t1 * t1 * t;
            double f2 = 3.0 * t1 * t * t;
            double f3 = t * t * t;
            return this.mY1 * f1 + this.mY2 * f2 + f3;
        }

        private double getDiffX(double t) {
            double t1 = 1.0 - t;
            return 3.0 * t1 * t1 * this.mX1 + 6.0 * t1 * t * (this.mX2 - this.mX1) + 3.0 * t * t * (1.0 - this.mX2);
        }

        private double getDiffY(double t) {
            double t1 = 1.0 - t;
            return 3.0 * t1 * t1 * this.mY1 + 6.0 * t1 * t * (this.mY2 - this.mY1) + 3.0 * t * t * (1.0 - this.mY2);
        }

        @Override
        public double getDiff(double x) {
            double t = 0.5;
            double range = 0.5;
            while (range > sDError) {
                double tx = this.getX(t);
                range *= 0.5;
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) / (x2 - x1);
        }

        @Override
        public double get(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return 1.0;
            }
            double t = 0.5;
            double range = 0.5;
            while (range > sError) {
                double tx = this.getX(t);
                range *= 0.5;
                if (tx < x) {
                    t += range;
                    continue;
                }
                t -= range;
            }
            double x1 = this.getX(t - range);
            double x2 = this.getX(t + range);
            double y1 = this.getY(t - range);
            double y2 = this.getY(t + range);
            return (y2 - y1) * (x - x1) / (x2 - x1) + y1;
        }
    }
}

