/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.Motion;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.utils.Easing;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class MotionPaths
implements Comparable<MotionPaths> {
    public static final String TAG = "MotionPaths";
    public static final boolean DEBUG = false;
    public static final boolean OLD_WAY = false;
    static final int OFF_POSITION = 0;
    static final int OFF_X = 1;
    static final int OFF_Y = 2;
    static final int OFF_WIDTH = 3;
    static final int OFF_HEIGHT = 4;
    static final int OFF_PATH_ROTATE = 5;
    public static final int PERPENDICULAR = 1;
    public static final int CARTESIAN = 0;
    public static final int SCREEN = 2;
    static String[] sNames = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
    public String mId;
    Easing mKeyFrameEasing;
    int mDrawPath = 0;
    float mTime;
    float mPosition;
    float mX;
    float mY;
    float mWidth;
    float mHeight;
    float mPathRotate = Float.NaN;
    float mProgress = Float.NaN;
    int mPathMotionArc = -1;
    String mAnimateRelativeTo = null;
    float mRelativeAngle = Float.NaN;
    Motion mRelativeToController = null;
    HashMap<String, CustomVariable> mCustomAttributes = new HashMap();
    int mMode = 0;
    int mAnimateCircleAngleTo;
    double[] mTempValue = new double[18];
    double[] mTempDelta = new double[18];

    public MotionPaths() {
    }

    void initCartesian(MotionKeyPosition c, MotionPaths startTimePoint, MotionPaths endTimePoint) {
        float position = (float)c.mFramePosition / 100.0f;
        MotionPaths point = this;
        point.mTime = position;
        this.mDrawPath = c.mDrawPath;
        float scaleWidth = Float.isNaN(c.mPercentWidth) ? position : c.mPercentWidth;
        float scaleHeight = Float.isNaN(c.mPercentHeight) ? position : c.mPercentHeight;
        float scaleX = endTimePoint.mWidth - startTimePoint.mWidth;
        float scaleY = endTimePoint.mHeight - startTimePoint.mHeight;
        point.mPosition = point.mTime;
        float path = position;
        float startCenterX = startTimePoint.mX + startTimePoint.mWidth / 2.0f;
        float startCenterY = startTimePoint.mY + startTimePoint.mHeight / 2.0f;
        float endCenterX = endTimePoint.mX + endTimePoint.mWidth / 2.0f;
        float endCenterY = endTimePoint.mY + endTimePoint.mHeight / 2.0f;
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        point.mX = (int)(startTimePoint.mX + pathVectorX * path - scaleX * scaleWidth / 2.0f);
        point.mY = (int)(startTimePoint.mY + pathVectorY * path - scaleY * scaleHeight / 2.0f);
        point.mWidth = (int)(startTimePoint.mWidth + scaleX * scaleWidth);
        point.mHeight = (int)(startTimePoint.mHeight + scaleY * scaleHeight);
        float dxdx = Float.isNaN(c.mPercentX) ? position : c.mPercentX;
        float dydx = Float.isNaN(c.mAltPercentY) ? 0.0f : c.mAltPercentY;
        float dydy = Float.isNaN(c.mPercentY) ? position : c.mPercentY;
        float dxdy = Float.isNaN(c.mAltPercentX) ? 0.0f : c.mAltPercentX;
        point.mMode = 0;
        point.mX = (int)(startTimePoint.mX + pathVectorX * dxdx + pathVectorY * dxdy - scaleX * scaleWidth / 2.0f);
        point.mY = (int)(startTimePoint.mY + pathVectorX * dydx + pathVectorY * dydy - scaleY * scaleHeight / 2.0f);
        point.mKeyFrameEasing = Easing.getInterpolator(c.mTransitionEasing);
        point.mPathMotionArc = c.mPathMotionArc;
    }

    public MotionPaths(int parentWidth, int parentHeight, MotionKeyPosition c, MotionPaths startTimePoint, MotionPaths endTimePoint) {
        if (startTimePoint.mAnimateRelativeTo != null) {
            this.initPolar(parentWidth, parentHeight, c, startTimePoint, endTimePoint);
            return;
        }
        switch (c.mPositionType) {
            case 2: {
                this.initScreen(parentWidth, parentHeight, c, startTimePoint, endTimePoint);
                return;
            }
            case 1: {
                this.initPath(c, startTimePoint, endTimePoint);
                return;
            }
        }
        this.initCartesian(c, startTimePoint, endTimePoint);
    }

    void initPolar(int parentWidth, int parentHeight, MotionKeyPosition c, MotionPaths s, MotionPaths e) {
        float position;
        this.mTime = position = (float)c.mFramePosition / 100.0f;
        this.mDrawPath = c.mDrawPath;
        this.mMode = c.mPositionType;
        float scaleWidth = Float.isNaN(c.mPercentWidth) ? position : c.mPercentWidth;
        float scaleHeight = Float.isNaN(c.mPercentHeight) ? position : c.mPercentHeight;
        float scaleX = e.mWidth - s.mWidth;
        float scaleY = e.mHeight - s.mHeight;
        this.mPosition = this.mTime;
        this.mWidth = (int)(s.mWidth + scaleX * scaleWidth);
        this.mHeight = (int)(s.mHeight + scaleY * scaleHeight);
        float startfactor = 1.0f - position;
        float endfactor = position;
        switch (c.mPositionType) {
            case 2: {
                this.mX = Float.isNaN(c.mPercentX) ? position * (e.mX - s.mX) + s.mX : c.mPercentX * Math.min(scaleHeight, scaleWidth);
                this.mY = Float.isNaN(c.mPercentY) ? position * (e.mY - s.mY) + s.mY : c.mPercentY;
                break;
            }
            case 1: {
                this.mX = (Float.isNaN(c.mPercentX) ? position : c.mPercentX) * (e.mX - s.mX) + s.mX;
                this.mY = (Float.isNaN(c.mPercentY) ? position : c.mPercentY) * (e.mY - s.mY) + s.mY;
                break;
            }
            default: {
                this.mX = (Float.isNaN(c.mPercentX) ? position : c.mPercentX) * (e.mX - s.mX) + s.mX;
                this.mY = (Float.isNaN(c.mPercentY) ? position : c.mPercentY) * (e.mY - s.mY) + s.mY;
            }
        }
        this.mAnimateRelativeTo = s.mAnimateRelativeTo;
        this.mKeyFrameEasing = Easing.getInterpolator(c.mTransitionEasing);
        this.mPathMotionArc = c.mPathMotionArc;
    }

    public void setupRelative(Motion mc, MotionPaths relative) {
        double dx = this.mX + this.mWidth / 2.0f - relative.mX - relative.mWidth / 2.0f;
        double dy = this.mY + this.mHeight / 2.0f - relative.mY - relative.mHeight / 2.0f;
        this.mRelativeToController = mc;
        this.mX = (float)Math.hypot(dy, dx);
        this.mY = Float.isNaN(this.mRelativeAngle) ? (float)(Math.atan2(dy, dx) + 1.5707963267948966) : (float)Math.toRadians(this.mRelativeAngle);
    }

    void initScreen(int parentWidth, int parentHeight, MotionKeyPosition c, MotionPaths startTimePoint, MotionPaths endTimePoint) {
        float position = (float)c.mFramePosition / 100.0f;
        MotionPaths point = this;
        point.mTime = position;
        this.mDrawPath = c.mDrawPath;
        float scaleWidth = Float.isNaN(c.mPercentWidth) ? position : c.mPercentWidth;
        float scaleHeight = Float.isNaN(c.mPercentHeight) ? position : c.mPercentHeight;
        float scaleX = endTimePoint.mWidth - startTimePoint.mWidth;
        float scaleY = endTimePoint.mHeight - startTimePoint.mHeight;
        point.mPosition = point.mTime;
        float path = position;
        float startCenterX = startTimePoint.mX + startTimePoint.mWidth / 2.0f;
        float startCenterY = startTimePoint.mY + startTimePoint.mHeight / 2.0f;
        float endCenterX = endTimePoint.mX + endTimePoint.mWidth / 2.0f;
        float endCenterY = endTimePoint.mY + endTimePoint.mHeight / 2.0f;
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        point.mX = (int)(startTimePoint.mX + pathVectorX * path - scaleX * scaleWidth / 2.0f);
        point.mY = (int)(startTimePoint.mY + pathVectorY * path - scaleY * scaleHeight / 2.0f);
        point.mWidth = (int)(startTimePoint.mWidth + scaleX * scaleWidth);
        point.mHeight = (int)(startTimePoint.mHeight + scaleY * scaleHeight);
        point.mMode = 2;
        if (!Float.isNaN(c.mPercentX)) {
            point.mX = (int)(c.mPercentX * (float)(parentWidth -= (int)point.mWidth));
        }
        if (!Float.isNaN(c.mPercentY)) {
            point.mY = (int)(c.mPercentY * (float)(parentHeight -= (int)point.mHeight));
        }
        point.mAnimateRelativeTo = this.mAnimateRelativeTo;
        point.mKeyFrameEasing = Easing.getInterpolator(c.mTransitionEasing);
        point.mPathMotionArc = c.mPathMotionArc;
    }

    void initPath(MotionKeyPosition c, MotionPaths startTimePoint, MotionPaths endTimePoint) {
        float position = (float)c.mFramePosition / 100.0f;
        MotionPaths point = this;
        point.mTime = position;
        this.mDrawPath = c.mDrawPath;
        float scaleWidth = Float.isNaN(c.mPercentWidth) ? position : c.mPercentWidth;
        float scaleHeight = Float.isNaN(c.mPercentHeight) ? position : c.mPercentHeight;
        float scaleX = endTimePoint.mWidth - startTimePoint.mWidth;
        float scaleY = endTimePoint.mHeight - startTimePoint.mHeight;
        point.mPosition = point.mTime;
        float path = Float.isNaN(c.mPercentX) ? position : c.mPercentX;
        float startCenterX = startTimePoint.mX + startTimePoint.mWidth / 2.0f;
        float startCenterY = startTimePoint.mY + startTimePoint.mHeight / 2.0f;
        float endCenterX = endTimePoint.mX + endTimePoint.mWidth / 2.0f;
        float endCenterY = endTimePoint.mY + endTimePoint.mHeight / 2.0f;
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        point.mX = (int)(startTimePoint.mX + pathVectorX * path - scaleX * scaleWidth / 2.0f);
        point.mY = (int)(startTimePoint.mY + pathVectorY * path - scaleY * scaleHeight / 2.0f);
        point.mWidth = (int)(startTimePoint.mWidth + scaleX * scaleWidth);
        point.mHeight = (int)(startTimePoint.mHeight + scaleY * scaleHeight);
        float perpendicular = Float.isNaN(c.mPercentY) ? 0.0f : c.mPercentY;
        float perpendicularX = -pathVectorY;
        float perpendicularY = pathVectorX;
        float normalX = perpendicularX * perpendicular;
        float normalY = perpendicularY * perpendicular;
        point.mMode = 1;
        point.mX = (int)(startTimePoint.mX + pathVectorX * path - scaleX * scaleWidth / 2.0f);
        point.mY = (int)(startTimePoint.mY + pathVectorY * path - scaleY * scaleHeight / 2.0f);
        point.mX += normalX;
        point.mY += normalY;
        point.mAnimateRelativeTo = this.mAnimateRelativeTo;
        point.mKeyFrameEasing = Easing.getInterpolator(c.mTransitionEasing);
        point.mPathMotionArc = c.mPathMotionArc;
    }

    private static float xRotate(float sin, float cos, float cx, float cy, float x, float y) {
        return (x -= cx) * cos - (y -= cy) * sin + cx;
    }

    private static float yRotate(float sin, float cos, float cx, float cy, float x, float y) {
        return (x -= cx) * sin + (y -= cy) * cos + cy;
    }

    private boolean diff(float a, float b) {
        if (Float.isNaN(a) || Float.isNaN(b)) {
            return Float.isNaN(a) != Float.isNaN(b);
        }
        return Math.abs(a - b) > 1.0E-6f;
    }

    void different(MotionPaths points, boolean[] mask, String[] custom, boolean arcMode) {
        int c = 0;
        boolean diffx = this.diff(this.mX, points.mX);
        boolean diffy = this.diff(this.mY, points.mY);
        int n = c++;
        mask[n] = mask[n] | this.diff(this.mPosition, points.mPosition);
        int n2 = c++;
        mask[n2] = mask[n2] | (diffx || diffy || arcMode);
        int n3 = c++;
        mask[n3] = mask[n3] | (diffx || diffy || arcMode);
        int n4 = c++;
        mask[n4] = mask[n4] | this.diff(this.mWidth, points.mWidth);
        int n5 = c++;
        mask[n5] = mask[n5] | this.diff(this.mHeight, points.mHeight);
    }

    void getCenter(double p, int[] toUse, double[] data, float[] point, int offset) {
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float translationX = 0.0f;
        float translationY = 0.0f;
        block6: for (int i = 0; i < toUse.length; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            this.mRelativeToController.getCenter(p, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            v_x = (float)((double)rx + (double)radius * Math.sin(angle) - (double)(v_width / 2.0f));
            v_y = (float)((double)ry - (double)radius * Math.cos(angle) - (double)(v_height / 2.0f));
        }
        point[offset] = v_x + v_width / 2.0f + translationX;
        point[offset + 1] = v_y + v_height / 2.0f + translationY;
    }

    void getCenter(double p, int[] toUse, double[] data, float[] point, double[] vdata, float[] velocity) {
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float dv_x = 0.0f;
        float dv_y = 0.0f;
        float dv_width = 0.0f;
        float dv_height = 0.0f;
        float translationX = 0.0f;
        float translationY = 0.0f;
        block6: for (int i = 0; i < toUse.length; ++i) {
            float value = (float)data[i];
            float dvalue = (float)vdata[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    dv_x = dvalue;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    dv_y = dvalue;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    dv_width = dvalue;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                    dv_height = dvalue;
                }
            }
        }
        float dpos_x = dv_x + dv_width / 2.0f;
        float dpos_y = dv_y + dv_height / 2.0f;
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            this.mRelativeToController.getCenter(p, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            float dradius = dv_x;
            float dangle = dv_y;
            float drx = vel[0];
            float dry = vel[1];
            v_x = (float)((double)rx + (double)radius * Math.sin(angle) - (double)(v_width / 2.0f));
            v_y = (float)((double)ry - (double)radius * Math.cos(angle) - (double)(v_height / 2.0f));
            dpos_x = (float)((double)drx + (double)dradius * Math.sin(angle) + Math.cos(angle) * (double)dangle);
            dpos_y = (float)((double)dry - (double)dradius * Math.cos(angle) + Math.sin(angle) * (double)dangle);
        }
        point[0] = v_x + v_width / 2.0f + translationX;
        point[1] = v_y + v_height / 2.0f + translationY;
        velocity[0] = dpos_x;
        velocity[1] = dpos_y;
    }

    void getCenterVelocity(double p, int[] toUse, double[] data, float[] point, int offset) {
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float translationX = 0.0f;
        float translationY = 0.0f;
        block6: for (int i = 0; i < toUse.length; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            this.mRelativeToController.getCenter(p, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            v_x = (float)((double)rx + (double)radius * Math.sin(angle) - (double)(v_width / 2.0f));
            v_y = (float)((double)ry - (double)radius * Math.cos(angle) - (double)(v_height / 2.0f));
        }
        point[offset] = v_x + v_width / 2.0f + translationX;
        point[offset + 1] = v_y + v_height / 2.0f + translationY;
    }

    void getBounds(int[] toUse, double[] data, float[] point, int offset) {
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        block6: for (int i = 0; i < toUse.length; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 1: {
                    v_x = value;
                    continue block6;
                }
                case 2: {
                    v_y = value;
                    continue block6;
                }
                case 3: {
                    v_width = value;
                    continue block6;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        point[offset] = v_width;
        point[offset + 1] = v_height;
    }

    void setView(float position, MotionWidget view, int[] toUse, double[] data, double[] slope, double[] cycle) {
        int i;
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float dv_x = 0.0f;
        float dv_y = 0.0f;
        float dv_width = 0.0f;
        float dv_height = 0.0f;
        float delta_path = 0.0f;
        float path_rotate = Float.NaN;
        if (toUse.length != 0 && this.mTempValue.length <= toUse[toUse.length - 1]) {
            int scratch_data_length = toUse[toUse.length - 1] + 1;
            this.mTempValue = new double[scratch_data_length];
            this.mTempDelta = new double[scratch_data_length];
        }
        Arrays.fill(this.mTempValue, Double.NaN);
        for (i = 0; i < toUse.length; ++i) {
            this.mTempValue[toUse[i]] = data[i];
            this.mTempDelta[toUse[i]] = slope[i];
        }
        block9: for (i = 0; i < this.mTempValue.length; ++i) {
            if (Double.isNaN(this.mTempValue[i]) && (cycle == null || cycle[i] == 0.0)) continue;
            double deltaCycle = cycle != null ? cycle[i] : 0.0;
            float value = (float)(Double.isNaN(this.mTempValue[i]) ? deltaCycle : this.mTempValue[i] + deltaCycle);
            float dvalue = (float)this.mTempDelta[i];
            switch (i) {
                case 0: {
                    delta_path = value;
                    continue block9;
                }
                case 1: {
                    v_x = value;
                    dv_x = dvalue;
                    continue block9;
                }
                case 2: {
                    v_y = value;
                    dv_y = dvalue;
                    continue block9;
                }
                case 3: {
                    v_width = value;
                    dv_width = dvalue;
                    continue block9;
                }
                case 4: {
                    v_height = value;
                    dv_height = dvalue;
                    continue block9;
                }
                case 5: {
                    path_rotate = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float[] pos = new float[2];
            float[] vel = new float[2];
            this.mRelativeToController.getCenter(position, pos, vel);
            float rx = pos[0];
            float ry = pos[1];
            float radius = v_x;
            float angle = v_y;
            float dradius = dv_x;
            float dangle = dv_y;
            float drx = vel[0];
            float dry = vel[1];
            float pos_x = (float)((double)rx + (double)radius * Math.sin(angle) - (double)(v_width / 2.0f));
            float pos_y = (float)((double)ry - (double)radius * Math.cos(angle) - (double)(v_height / 2.0f));
            float dpos_x = (float)((double)drx + (double)dradius * Math.sin(angle) + (double)radius * Math.cos(angle) * (double)dangle);
            float dpos_y = (float)((double)dry - (double)dradius * Math.cos(angle) + (double)radius * Math.sin(angle) * (double)dangle);
            dv_x = dpos_x;
            dv_y = dpos_y;
            v_x = pos_x;
            v_y = pos_y;
            if (slope.length >= 2) {
                slope[0] = dpos_x;
                slope[1] = dpos_y;
            }
            if (!Float.isNaN(path_rotate)) {
                float rot = (float)((double)path_rotate + Math.toDegrees(Math.atan2(dv_y, dv_x)));
                view.setRotationZ(rot);
            }
        } else if (!Float.isNaN(path_rotate)) {
            float rot = 0.0f;
            float dx = dv_x + dv_width / 2.0f;
            float dy = dv_y + dv_height / 2.0f;
            view.setRotationZ(rot += (float)((double)path_rotate + Math.toDegrees(Math.atan2(dy, dx))));
        }
        int l = (int)(0.5f + v_x);
        int t = (int)(0.5f + v_y);
        int r = (int)(0.5f + v_x + v_width);
        int b = (int)(0.5f + v_y + v_height);
        int i_width = r - l;
        int i_height = b - t;
        view.layout(l, t, r, b);
    }

    void getRect(int[] toUse, double[] data, float[] path, int offset) {
        float v_x = this.mX;
        float v_y = this.mY;
        float v_width = this.mWidth;
        float v_height = this.mHeight;
        float delta_path = 0.0f;
        float rotation = 0.0f;
        float alpha = 0.0f;
        float rotationX = 0.0f;
        float rotationY = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float pivotX = Float.NaN;
        float pivotY = Float.NaN;
        float translationX = 0.0f;
        float translationY = 0.0f;
        block7: for (int i = 0; i < toUse.length; ++i) {
            float value = (float)data[i];
            switch (toUse[i]) {
                case 0: {
                    delta_path = value;
                    continue block7;
                }
                case 1: {
                    v_x = value;
                    continue block7;
                }
                case 2: {
                    v_y = value;
                    continue block7;
                }
                case 3: {
                    v_width = value;
                    continue block7;
                }
                case 4: {
                    v_height = value;
                }
            }
        }
        if (this.mRelativeToController != null) {
            float rx = this.mRelativeToController.getCenterX();
            float ry = this.mRelativeToController.getCenterY();
            float radius = v_x;
            float angle = v_y;
            v_x = (float)((double)rx + (double)radius * Math.sin(angle) - (double)(v_width / 2.0f));
            v_y = (float)((double)ry - (double)radius * Math.cos(angle) - (double)(v_height / 2.0f));
        }
        float x1 = v_x;
        float y1 = v_y;
        float x2 = v_x + v_width;
        float y2 = y1;
        float x3 = x2;
        float y3 = v_y + v_height;
        float x4 = x1;
        float y4 = y3;
        float cx = x1 + v_width / 2.0f;
        float cy = y1 + v_height / 2.0f;
        if (!Float.isNaN(pivotX)) {
            cx = x1 + (x2 - x1) * pivotX;
        }
        if (!Float.isNaN(pivotY)) {
            cy = y1 + (y3 - y1) * pivotY;
        }
        if (scaleX != 1.0f) {
            float midx = (x1 + x2) / 2.0f;
            x1 = (x1 - midx) * scaleX + midx;
            x2 = (x2 - midx) * scaleX + midx;
            x3 = (x3 - midx) * scaleX + midx;
            x4 = (x4 - midx) * scaleX + midx;
        }
        if (scaleY != 1.0f) {
            float midy = (y1 + y3) / 2.0f;
            y1 = (y1 - midy) * scaleY + midy;
            y2 = (y2 - midy) * scaleY + midy;
            y3 = (y3 - midy) * scaleY + midy;
            y4 = (y4 - midy) * scaleY + midy;
        }
        if (rotation != 0.0f) {
            float sin = (float)Math.sin(Math.toRadians(rotation));
            float cos = (float)Math.cos(Math.toRadians(rotation));
            float tx1 = MotionPaths.xRotate(sin, cos, cx, cy, x1, y1);
            float ty1 = MotionPaths.yRotate(sin, cos, cx, cy, x1, y1);
            float tx2 = MotionPaths.xRotate(sin, cos, cx, cy, x2, y2);
            float ty2 = MotionPaths.yRotate(sin, cos, cx, cy, x2, y2);
            float tx3 = MotionPaths.xRotate(sin, cos, cx, cy, x3, y3);
            float ty3 = MotionPaths.yRotate(sin, cos, cx, cy, x3, y3);
            float tx4 = MotionPaths.xRotate(sin, cos, cx, cy, x4, y4);
            float ty4 = MotionPaths.yRotate(sin, cos, cx, cy, x4, y4);
            x1 = tx1;
            y1 = ty1;
            x2 = tx2;
            y2 = ty2;
            x3 = tx3;
            y3 = ty3;
            x4 = tx4;
            y4 = ty4;
        }
        x1 += translationX;
        y1 += translationY;
        x2 += translationX;
        y2 += translationY;
        x3 += translationX;
        y3 += translationY;
        x4 += translationX;
        y4 += translationY;
        path[offset++] = x1;
        path[offset++] = y1;
        path[offset++] = x2;
        path[offset++] = y2;
        path[offset++] = x3;
        path[offset++] = y3;
        path[offset++] = x4;
        path[offset++] = y4;
    }

    void setDpDt(float locationX, float locationY, float[] mAnchorDpDt, int[] toUse, double[] deltaData, double[] data) {
        float d_x = 0.0f;
        float d_y = 0.0f;
        float d_width = 0.0f;
        float d_height = 0.0f;
        float deltaScaleX = 0.0f;
        float deltaScaleY = 0.0f;
        float mPathRotate = Float.NaN;
        float deltaTranslationX = 0.0f;
        float deltaTranslationY = 0.0f;
        String mod = " dd = ";
        block7: for (int i = 0; i < toUse.length; ++i) {
            float deltaV = (float)deltaData[i];
            switch (toUse[i]) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    d_x = deltaV;
                    continue block7;
                }
                case 2: {
                    d_y = deltaV;
                    continue block7;
                }
                case 3: {
                    d_width = deltaV;
                    continue block7;
                }
                case 4: {
                    d_height = deltaV;
                }
            }
        }
        float deltaX = d_x - deltaScaleX * d_width / 2.0f;
        float deltaY = d_y - deltaScaleY * d_height / 2.0f;
        float deltaWidth = d_width * (1.0f + deltaScaleX);
        float deltaHeight = d_height * (1.0f + deltaScaleY);
        float deltaRight = deltaX + deltaWidth;
        float deltaBottom = deltaY + deltaHeight;
        mAnchorDpDt[0] = deltaX * (1.0f - locationX) + deltaRight * locationX + deltaTranslationX;
        mAnchorDpDt[1] = deltaY * (1.0f - locationY) + deltaBottom * locationY + deltaTranslationY;
    }

    void fillStandard(double[] data, int[] toUse) {
        float[] set = new float[]{this.mPosition, this.mX, this.mY, this.mWidth, this.mHeight, this.mPathRotate};
        int c = 0;
        for (int i = 0; i < toUse.length; ++i) {
            if (toUse[i] >= set.length) continue;
            data[c++] = set[toUse[i]];
        }
    }

    boolean hasCustomData(String name) {
        return this.mCustomAttributes.containsKey(name);
    }

    int getCustomDataCount(String name) {
        CustomVariable a = this.mCustomAttributes.get(name);
        if (a == null) {
            return 0;
        }
        return a.numberOfInterpolatedValues();
    }

    int getCustomData(String name, double[] value, int offset) {
        CustomVariable a = this.mCustomAttributes.get(name);
        if (a == null) {
            return 0;
        }
        if (a.numberOfInterpolatedValues() == 1) {
            value[offset] = a.getValueToInterpolate();
            return 1;
        }
        int n = a.numberOfInterpolatedValues();
        float[] f = new float[n];
        a.getValuesToInterpolate(f);
        for (int i = 0; i < n; ++i) {
            value[offset++] = f[i];
        }
        return n;
    }

    void setBounds(float x, float y, float w, float h) {
        this.mX = x;
        this.mY = y;
        this.mWidth = w;
        this.mHeight = h;
    }

    @Override
    public int compareTo(MotionPaths o) {
        return Float.compare(this.mPosition, o.mPosition);
    }

    public void applyParameters(MotionWidget c) {
        MotionPaths point = this;
        point.mKeyFrameEasing = Easing.getInterpolator(c.mMotion.mTransitionEasing);
        point.mPathMotionArc = c.mMotion.mPathMotionArc;
        point.mAnimateRelativeTo = c.mMotion.mAnimateRelativeTo;
        point.mPathRotate = c.mMotion.mPathRotate;
        point.mDrawPath = c.mMotion.mDrawPath;
        point.mAnimateCircleAngleTo = c.mMotion.mAnimateCircleAngleTo;
        point.mProgress = c.mPropertySet.mProgress;
        if (c.mWidgetFrame != null && c.mWidgetFrame.widget != null) {
            point.mRelativeAngle = c.mWidgetFrame.widget.mCircleConstraintAngle;
        }
        Set<String> at = c.getCustomAttributeNames();
        for (String s : at) {
            CustomVariable attr = c.getCustomAttribute(s);
            if (attr == null || !attr.isContinuous()) continue;
            this.mCustomAttributes.put(s, attr);
        }
    }

    public void configureRelativeTo(Motion toOrbit) {
        double[] p = toOrbit.getPos(this.mProgress);
    }
}

