/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.annotation.NonNull;
import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.CorePixelDp;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.helpers.AlignHorizontallyReference;
import androidx.constraintlayout.core.state.helpers.AlignVerticallyReference;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.FlowReference;
import androidx.constraintlayout.core.state.helpers.GridReference;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import androidx.constraintlayout.core.state.helpers.HorizontalChainReference;
import androidx.constraintlayout.core.state.helpers.VerticalChainReference;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class State {
    private CorePixelDp mDpToPixel;
    private boolean mIsLtr = true;
    protected HashMap<Object, Reference> mReferences = new HashMap();
    protected HashMap<Object, HelperReference> mHelperReferences = new HashMap();
    HashMap<String, ArrayList<String>> mTags = new HashMap();
    static final int UNKNOWN = -1;
    static final int CONSTRAINT_SPREAD = 0;
    static final int CONSTRAINT_WRAP = 1;
    static final int CONSTRAINT_RATIO = 2;
    public static final Integer PARENT = 0;
    public final ConstraintReference mParent = new ConstraintReference(this);
    private int mNumHelpers = 0;
    ArrayList<Object> mBaselineNeeded = new ArrayList();
    ArrayList<ConstraintWidget> mBaselineNeededWidgets = new ArrayList();
    boolean mDirtyBaselineNeededWidgets = true;

    public State() {
        this.mParent.setKey(PARENT);
        this.mReferences.put(PARENT, this.mParent);
    }

    CorePixelDp getDpToPixel() {
        return this.mDpToPixel;
    }

    public void setDpToPixel(CorePixelDp dpToPixel) {
        this.mDpToPixel = dpToPixel;
    }

    public void setLtr(boolean isLtr) {
        this.mIsLtr = isLtr;
    }

    public boolean isLtr() {
        return this.mIsLtr;
    }

    public void reset() {
        for (Object ref : this.mReferences.keySet()) {
            this.mReferences.get(ref).getConstraintWidget().reset();
        }
        this.mReferences.clear();
        this.mReferences.put(PARENT, this.mParent);
        this.mHelperReferences.clear();
        this.mTags.clear();
        this.mBaselineNeeded.clear();
        this.mDirtyBaselineNeededWidgets = true;
    }

    public int convertDimension(Object value) {
        if (value instanceof Float) {
            return Math.round(((Float)value).floatValue());
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public ConstraintReference createConstraintReference(Object key) {
        return new ConstraintReference(this);
    }

    public boolean sameFixedWidth(int width) {
        return this.mParent.getWidth().equalsFixedValue(width);
    }

    public boolean sameFixedHeight(int height) {
        return this.mParent.getHeight().equalsFixedValue(height);
    }

    public State width(Dimension dimension) {
        return this.setWidth(dimension);
    }

    public State height(Dimension dimension) {
        return this.setHeight(dimension);
    }

    public State setWidth(Dimension dimension) {
        this.mParent.setWidth(dimension);
        return this;
    }

    public State setHeight(Dimension dimension) {
        this.mParent.setHeight(dimension);
        return this;
    }

    Reference reference(Object key) {
        return this.mReferences.get(key);
    }

    public ConstraintReference constraints(Object key) {
        Reference reference = this.mReferences.get(key);
        if (reference == null) {
            reference = this.createConstraintReference(key);
            this.mReferences.put(key, reference);
            reference.setKey(key);
        }
        if (reference instanceof ConstraintReference) {
            return (ConstraintReference)reference;
        }
        return null;
    }

    private String createHelperKey() {
        return "__HELPER_KEY_" + this.mNumHelpers++ + "__";
    }

    public HelperReference helper(Object key, Helper type) {
        HelperReference reference;
        if (key == null) {
            key = this.createHelperKey();
        }
        if ((reference = this.mHelperReferences.get(key)) == null) {
            switch (type) {
                case HORIZONTAL_CHAIN: {
                    reference = new HorizontalChainReference(this);
                    break;
                }
                case VERTICAL_CHAIN: {
                    reference = new VerticalChainReference(this);
                    break;
                }
                case ALIGN_HORIZONTALLY: {
                    reference = new AlignHorizontallyReference(this);
                    break;
                }
                case ALIGN_VERTICALLY: {
                    reference = new AlignVerticallyReference(this);
                    break;
                }
                case BARRIER: {
                    reference = new BarrierReference(this);
                    break;
                }
                case VERTICAL_FLOW: 
                case HORIZONTAL_FLOW: {
                    reference = new FlowReference(this, type);
                    break;
                }
                case GRID: 
                case ROW: 
                case COLUMN: {
                    reference = new GridReference(this, type);
                    break;
                }
                default: {
                    reference = new HelperReference(this, type);
                }
            }
            reference.setKey(key);
            this.mHelperReferences.put(key, reference);
        }
        return reference;
    }

    public GuidelineReference horizontalGuideline(Object key) {
        return this.guideline(key, 0);
    }

    public GuidelineReference verticalGuideline(Object key) {
        return this.guideline(key, 1);
    }

    public GuidelineReference guideline(Object key, int orientation) {
        ConstraintReference reference = this.constraints(key);
        if (reference.getFacade() == null || !(reference.getFacade() instanceof GuidelineReference)) {
            GuidelineReference guidelineReference = new GuidelineReference(this);
            guidelineReference.setOrientation(orientation);
            guidelineReference.setKey(key);
            reference.setFacade(guidelineReference);
        }
        return (GuidelineReference)reference.getFacade();
    }

    public BarrierReference barrier(Object key, Direction direction) {
        ConstraintReference reference = this.constraints(key);
        if (reference.getFacade() == null || !(reference.getFacade() instanceof BarrierReference)) {
            BarrierReference barrierReference = new BarrierReference(this);
            barrierReference.setBarrierDirection(direction);
            reference.setFacade(barrierReference);
        }
        return (BarrierReference)reference.getFacade();
    }

    @NonNull
    public GridReference getGrid(@NonNull Object key, @NonNull String gridType) {
        ConstraintReference reference = this.constraints(key);
        if (reference.getFacade() == null || !(reference.getFacade() instanceof GridReference)) {
            Helper Type2 = Helper.GRID;
            if (gridType.charAt(0) == 'r') {
                Type2 = Helper.ROW;
            } else if (gridType.charAt(0) == 'c') {
                Type2 = Helper.COLUMN;
            }
            GridReference gridReference = new GridReference(this, Type2);
            reference.setFacade(gridReference);
        }
        return (GridReference)reference.getFacade();
    }

    public FlowReference getFlow(Object key, boolean vertical) {
        ConstraintReference reference = this.constraints(key);
        if (reference.getFacade() == null || !(reference.getFacade() instanceof FlowReference)) {
            FlowReference flowReference = vertical ? new FlowReference(this, Helper.VERTICAL_FLOW) : new FlowReference(this, Helper.HORIZONTAL_FLOW);
            reference.setFacade(flowReference);
        }
        return (FlowReference)reference.getFacade();
    }

    public VerticalChainReference verticalChain() {
        return (VerticalChainReference)this.helper(null, Helper.VERTICAL_CHAIN);
    }

    public VerticalChainReference verticalChain(Object ... references) {
        VerticalChainReference reference = (VerticalChainReference)this.helper(null, Helper.VERTICAL_CHAIN);
        reference.add(references);
        return reference;
    }

    public HorizontalChainReference horizontalChain() {
        return (HorizontalChainReference)this.helper(null, Helper.HORIZONTAL_CHAIN);
    }

    public HorizontalChainReference horizontalChain(Object ... references) {
        HorizontalChainReference reference = (HorizontalChainReference)this.helper(null, Helper.HORIZONTAL_CHAIN);
        reference.add(references);
        return reference;
    }

    public FlowReference getVerticalFlow() {
        return (FlowReference)this.helper(null, Helper.VERTICAL_FLOW);
    }

    public FlowReference getVerticalFlow(Object ... references) {
        FlowReference reference = (FlowReference)this.helper(null, Helper.VERTICAL_FLOW);
        reference.add(references);
        return reference;
    }

    public FlowReference getHorizontalFlow() {
        return (FlowReference)this.helper(null, Helper.HORIZONTAL_FLOW);
    }

    public FlowReference getHorizontalFlow(Object ... references) {
        FlowReference reference = (FlowReference)this.helper(null, Helper.HORIZONTAL_FLOW);
        reference.add(references);
        return reference;
    }

    public AlignHorizontallyReference centerHorizontally(Object ... references) {
        AlignHorizontallyReference reference = (AlignHorizontallyReference)this.helper(null, Helper.ALIGN_HORIZONTALLY);
        reference.add(references);
        return reference;
    }

    public AlignVerticallyReference centerVertically(Object ... references) {
        AlignVerticallyReference reference = (AlignVerticallyReference)this.helper(null, Helper.ALIGN_VERTICALLY);
        reference.add(references);
        return reference;
    }

    public void directMapping() {
        for (Object key : this.mReferences.keySet()) {
            ConstraintReference ref = this.constraints(key);
            if (!(ref instanceof ConstraintReference)) continue;
            ConstraintReference reference = ref;
            reference.setView(key);
        }
    }

    public void map(Object key, Object view) {
        ConstraintReference ref = this.constraints(key);
        if (ref != null) {
            ref.setView(view);
        }
    }

    public void setTag(String key, String tag) {
        ConstraintReference ref = this.constraints(key);
        if (ref instanceof ConstraintReference) {
            ConstraintReference reference = ref;
            reference.setTag(tag);
            ArrayList<Object> list = null;
            if (!this.mTags.containsKey(tag)) {
                list = new ArrayList();
                this.mTags.put(tag, list);
            } else {
                list = this.mTags.get(tag);
            }
            list.add(key);
        }
    }

    public ArrayList<String> getIdsForTag(String tag) {
        if (this.mTags.containsKey(tag)) {
            return this.mTags.get(tag);
        }
        return null;
    }

    public void apply(ConstraintWidgetContainer container) {
        ConstraintWidget widget;
        Object constraintReference;
        HelperWidget helperWidget;
        Reference reference;
        container.removeAllChildren();
        this.mParent.getWidth().apply(this, container, 0);
        this.mParent.getHeight().apply(this, container, 1);
        for (Object key : this.mHelperReferences.keySet()) {
            reference = this.mHelperReferences.get(key);
            helperWidget = ((HelperReference)reference).getHelperWidget();
            if (helperWidget == null) continue;
            constraintReference = this.mReferences.get(key);
            if (constraintReference == null) {
                constraintReference = this.constraints(key);
            }
            constraintReference.setConstraintWidget(helperWidget);
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            if (reference == this.mParent || !(reference.getFacade() instanceof HelperReference) || (helperWidget = ((HelperReference)reference.getFacade()).getHelperWidget()) == null) continue;
            constraintReference = this.mReferences.get(key);
            if (constraintReference == null) {
                constraintReference = this.constraints(key);
            }
            constraintReference.setConstraintWidget(helperWidget);
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            if (reference != this.mParent) {
                widget = reference.getConstraintWidget();
                widget.setDebugName(reference.getKey().toString());
                widget.setParent(null);
                if (reference.getFacade() instanceof GuidelineReference) {
                    reference.apply();
                }
                container.add(widget);
                continue;
            }
            reference.setConstraintWidget(container);
        }
        for (Object key : this.mHelperReferences.keySet()) {
            reference = this.mHelperReferences.get(key);
            helperWidget = ((HelperReference)reference).getHelperWidget();
            if (helperWidget != null) {
                for (Object e : ((HelperReference)reference).mReferences) {
                    Reference constraintReference2 = this.mReferences.get(e);
                    ((HelperReference)reference).getHelperWidget().add(constraintReference2.getConstraintWidget());
                }
                ((HelperReference)reference).apply();
                continue;
            }
            ((HelperReference)reference).apply();
        }
        for (Object key : this.mReferences.keySet()) {
            HelperReference helperReference;
            HelperWidget helperWidget2;
            reference = this.mReferences.get(key);
            if (reference == this.mParent || !(reference.getFacade() instanceof HelperReference) || (helperWidget2 = (helperReference = (HelperReference)reference.getFacade()).getHelperWidget()) == null) continue;
            for (Object keyRef : helperReference.mReferences) {
                Reference constraintReference3 = this.mReferences.get(keyRef);
                if (constraintReference3 != null) {
                    helperWidget2.add(constraintReference3.getConstraintWidget());
                    continue;
                }
                if (keyRef instanceof Reference) {
                    helperWidget2.add(((Reference)keyRef).getConstraintWidget());
                    continue;
                }
                System.out.println("couldn't find reference for " + keyRef);
            }
            reference.apply();
        }
        for (Object key : this.mReferences.keySet()) {
            reference = this.mReferences.get(key);
            reference.apply();
            widget = reference.getConstraintWidget();
            if (widget == null || key == null) continue;
            widget.stringId = key.toString();
        }
    }

    public void baselineNeededFor(Object id) {
        this.mBaselineNeeded.add(id);
        this.mDirtyBaselineNeededWidgets = true;
    }

    public boolean isBaselineNeeded(ConstraintWidget constraintWidget) {
        if (this.mDirtyBaselineNeededWidgets) {
            this.mBaselineNeededWidgets.clear();
            for (Object id : this.mBaselineNeeded) {
                ConstraintWidget widget = this.mReferences.get(id).getConstraintWidget();
                if (widget == null) continue;
                this.mBaselineNeededWidgets.add(widget);
            }
            this.mDirtyBaselineNeededWidgets = false;
        }
        return this.mBaselineNeededWidgets.contains(constraintWidget);
    }

    public static enum Helper {
        HORIZONTAL_CHAIN,
        VERTICAL_CHAIN,
        ALIGN_HORIZONTALLY,
        ALIGN_VERTICALLY,
        BARRIER,
        LAYER,
        HORIZONTAL_FLOW,
        VERTICAL_FLOW,
        GRID,
        ROW,
        COLUMN,
        FLOW;

    }

    public static enum Direction {
        LEFT,
        RIGHT,
        START,
        END,
        TOP,
        BOTTOM;

    }

    public static enum Wrap {
        NONE,
        CHAIN,
        ALIGNED;

        public static Map<String, Wrap> wrapMap;
        public static Map<String, Integer> valueMap;

        public static int getValueByString(String str) {
            if (valueMap.containsKey(str)) {
                return valueMap.get(str);
            }
            return -1;
        }

        public static Wrap getChainByString(String str) {
            if (wrapMap.containsKey(str)) {
                return wrapMap.get(str);
            }
            return null;
        }

        static {
            wrapMap = new HashMap<String, Wrap>();
            valueMap = new HashMap<String, Integer>();
            wrapMap.put("none", NONE);
            wrapMap.put("chain", CHAIN);
            wrapMap.put("aligned", ALIGNED);
            valueMap.put("none", 0);
            valueMap.put("chain", 1);
            valueMap.put("aligned", 2);
        }
    }

    public static enum Chain {
        SPREAD,
        SPREAD_INSIDE,
        PACKED;

        public static Map<String, Chain> chainMap;
        public static Map<String, Integer> valueMap;

        public static int getValueByString(String str) {
            if (valueMap.containsKey(str)) {
                return valueMap.get(str);
            }
            return -1;
        }

        public static Chain getChainByString(String str) {
            if (chainMap.containsKey(str)) {
                return chainMap.get(str);
            }
            return null;
        }

        static {
            chainMap = new HashMap<String, Chain>();
            valueMap = new HashMap<String, Integer>();
            chainMap.put("packed", PACKED);
            chainMap.put("spread_inside", SPREAD_INSIDE);
            chainMap.put("spread", SPREAD);
            valueMap.put("packed", 2);
            valueMap.put("spread_inside", 1);
            valueMap.put("spread", 0);
        }
    }

    public static enum Constraint {
        LEFT_TO_LEFT,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        RIGHT_TO_RIGHT,
        START_TO_START,
        START_TO_END,
        END_TO_START,
        END_TO_END,
        TOP_TO_TOP,
        TOP_TO_BOTTOM,
        TOP_TO_BASELINE,
        BOTTOM_TO_TOP,
        BOTTOM_TO_BOTTOM,
        BOTTOM_TO_BASELINE,
        BASELINE_TO_BASELINE,
        BASELINE_TO_TOP,
        BASELINE_TO_BOTTOM,
        CENTER_HORIZONTALLY,
        CENTER_VERTICALLY,
        CIRCULAR_CONSTRAINT;

    }
}

