/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GridCore
extends VirtualLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SUB_GRID_BY_COL_ROW = 0;
    public static final int SPANS_RESPECT_WIDGET_ORDER = 1;
    private static final int DEFAULT_SIZE = 3;
    private static final int MAX_ROWS = 50;
    private static final int MAX_COLUMNS = 50;
    ConstraintWidgetContainer mContainer;
    private ConstraintWidget[] mBoxWidgets;
    private boolean mExtraSpaceHandled = false;
    private int mRows;
    private int mRowsSet;
    private int mColumns;
    private int mColumnsSet;
    private float mHorizontalGaps;
    private float mVerticalGaps;
    private String mRowWeights;
    private String mColumnWeights;
    private String mSpans;
    private String mSkips;
    private int mOrientation;
    private int mNextAvailableIndex = 0;
    private boolean[][] mPositionMatrix;
    Set<String> mSpanIds = new HashSet<String>();
    private int[][] mConstraintMatrix;
    private int[] mFlags;
    private int[][] mSpanMatrix;
    private int mSpanIndex = 0;
    private boolean mSpansRespectWidgetOrder = false;
    private boolean mSubGridByColRow = false;

    public GridCore() {
        this.updateActualRowsAndColumns();
        this.initMatrices();
    }

    public GridCore(int rows, int columns) {
        this.mRowsSet = rows;
        this.mColumnsSet = columns;
        if (rows > 50) {
            this.mRowsSet = 3;
        }
        if (columns > 50) {
            this.mColumnsSet = 3;
        }
        this.updateActualRowsAndColumns();
        this.initMatrices();
    }

    @Nullable
    public ConstraintWidgetContainer getContainer() {
        return this.mContainer;
    }

    public void setContainer(@NonNull ConstraintWidgetContainer container) {
        this.mContainer = container;
    }

    public void setSpans(@NonNull CharSequence spans) {
        if (this.mSpans != null && this.mSpans.equals(spans.toString())) {
            return;
        }
        this.mExtraSpaceHandled = false;
        this.mSpans = spans.toString();
    }

    public void setSkips(@NonNull String skips) {
        if (this.mSkips != null && this.mSkips.equals(skips)) {
            return;
        }
        this.mExtraSpaceHandled = false;
        this.mSkips = skips;
    }

    public float getHorizontalGaps() {
        return this.mHorizontalGaps;
    }

    public void setHorizontalGaps(float horizontalGaps) {
        if (horizontalGaps < 0.0f) {
            return;
        }
        if (this.mHorizontalGaps == horizontalGaps) {
            return;
        }
        this.mHorizontalGaps = horizontalGaps;
    }

    public float getVerticalGaps() {
        return this.mVerticalGaps;
    }

    public void setVerticalGaps(float verticalGaps) {
        if (verticalGaps < 0.0f) {
            return;
        }
        if (this.mVerticalGaps == verticalGaps) {
            return;
        }
        this.mVerticalGaps = verticalGaps;
    }

    @Nullable
    public String getRowWeights() {
        return this.mRowWeights;
    }

    public void setRowWeights(@NonNull String rowWeights) {
        if (this.mRowWeights != null && this.mRowWeights.equals(rowWeights)) {
            return;
        }
        this.mRowWeights = rowWeights;
    }

    @Nullable
    public String getColumnWeights() {
        return this.mColumnWeights;
    }

    public void setColumnWeights(@NonNull String columnWeights) {
        if (this.mColumnWeights != null && this.mColumnWeights.equals(columnWeights)) {
            return;
        }
        this.mColumnWeights = columnWeights;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            return;
        }
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
    }

    public void setRows(int rows) {
        if (rows > 50) {
            return;
        }
        if (this.mRowsSet == rows) {
            return;
        }
        this.mRowsSet = rows;
        this.updateActualRowsAndColumns();
        this.initVariables();
    }

    public void setColumns(int columns) {
        if (columns > 50) {
            return;
        }
        if (this.mColumnsSet == columns) {
            return;
        }
        this.mColumnsSet = columns;
        this.updateActualRowsAndColumns();
        this.initVariables();
    }

    @NonNull
    public int[] getFlags() {
        return this.mFlags;
    }

    public void setFlags(@NonNull int[] flags) {
        this.mFlags = flags;
    }

    private void handleSpans(int[][] spansMatrix) {
        if (this.mSpansRespectWidgetOrder) {
            return;
        }
        for (int i = 0; i < spansMatrix.length; ++i) {
            int col;
            int row = this.getRowByIndex(spansMatrix[i][0]);
            if (!this.invalidatePositions(row, col = this.getColByIndex(spansMatrix[i][0]), spansMatrix[i][1], spansMatrix[i][2])) {
                return;
            }
            this.connectWidget(this.mWidgets[i], row, col, spansMatrix[i][1], spansMatrix[i][2]);
            this.mSpanIds.add(this.mWidgets[i].stringId);
        }
    }

    private void arrangeWidgets() {
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            if (this.mSpanIds.contains(this.mWidgets[i].stringId)) continue;
            int position = this.getNextPosition();
            int row = this.getRowByIndex(position);
            int col = this.getColByIndex(position);
            if (position == -1) {
                return;
            }
            if (this.mSpansRespectWidgetOrder && this.mSpanMatrix != null && this.mSpanIndex < this.mSpanMatrix.length && this.mSpanMatrix[this.mSpanIndex][0] == position) {
                this.mPositionMatrix[row][col] = true;
                if (!this.invalidatePositions(row, col, this.mSpanMatrix[this.mSpanIndex][1], this.mSpanMatrix[this.mSpanIndex][2])) continue;
                this.connectWidget(this.mWidgets[i], row, col, this.mSpanMatrix[this.mSpanIndex][1], this.mSpanMatrix[this.mSpanIndex][2]);
                ++this.mSpanIndex;
                continue;
            }
            this.connectWidget(this.mWidgets[i], row, col, 1, 1);
        }
    }

    private void setupGrid(boolean isUpdate) {
        int[][] mSkips;
        if (this.mRows < 1 || this.mColumns < 1) {
            return;
        }
        this.handleFlags();
        if (isUpdate) {
            for (int i = 0; i < this.mPositionMatrix.length; ++i) {
                for (int j = 0; j < this.mPositionMatrix[0].length; ++j) {
                    this.mPositionMatrix[i][j] = true;
                }
            }
            this.mSpanIds.clear();
        }
        this.mNextAvailableIndex = 0;
        if (this.mSkips != null && !this.mSkips.trim().isEmpty() && (mSkips = this.parseSpans(this.mSkips, false)) != null) {
            this.handleSkips(mSkips);
        }
        if (this.mSpans != null && !this.mSpans.trim().isEmpty()) {
            this.mSpanMatrix = this.parseSpans(this.mSpans, true);
        }
        this.createBoxes();
        if (this.mSpanMatrix != null) {
            this.handleSpans(this.mSpanMatrix);
        }
    }

    private int getRowByIndex(int index) {
        if (this.mOrientation == 1) {
            return index % this.mRows;
        }
        return index / this.mColumns;
    }

    private int getColByIndex(int index) {
        if (this.mOrientation == 1) {
            return index / this.mRows;
        }
        return index % this.mColumns;
    }

    private void handleSkips(int[][] skipsMatrix) {
        for (int[] matrix : skipsMatrix) {
            int col;
            int row = this.getRowByIndex(matrix[0]);
            if (this.invalidatePositions(row, col = this.getColByIndex(matrix[0]), matrix[1], matrix[2])) continue;
            return;
        }
    }

    private boolean invalidatePositions(int startRow, int startColumn, int rowSpan, int columnSpan) {
        for (int i = startRow; i < startRow + rowSpan; ++i) {
            for (int j = startColumn; j < startColumn + columnSpan; ++j) {
                if (i >= this.mPositionMatrix.length || j >= this.mPositionMatrix[0].length || !this.mPositionMatrix[i][j]) {
                    return false;
                }
                this.mPositionMatrix[i][j] = false;
            }
        }
        return true;
    }

    private float[] parseWeights(int size, String str) {
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        String[] values = str.split(",");
        if (values.length != size) {
            return null;
        }
        float[] arr = new float[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Float.parseFloat(values[i].trim());
        }
        return arr;
    }

    private int getNextPosition() {
        int position = 0;
        boolean positionFound = false;
        while (!positionFound) {
            int col;
            if (this.mNextAvailableIndex >= this.mRows * this.mColumns) {
                return -1;
            }
            position = this.mNextAvailableIndex;
            int row = this.getRowByIndex(this.mNextAvailableIndex);
            if (this.mPositionMatrix[row][col = this.getColByIndex(this.mNextAvailableIndex)]) {
                this.mPositionMatrix[row][col] = false;
                positionFound = true;
            }
            ++this.mNextAvailableIndex;
        }
        return position;
    }

    private void updateActualRowsAndColumns() {
        if (this.mRowsSet == 0 || this.mColumnsSet == 0) {
            if (this.mColumnsSet > 0) {
                this.mColumns = this.mColumnsSet;
                this.mRows = (this.mWidgetsCount + this.mColumns - 1) / this.mColumnsSet;
            } else if (this.mRowsSet > 0) {
                this.mRows = this.mRowsSet;
                this.mColumns = (this.mWidgetsCount + this.mRowsSet - 1) / this.mRowsSet;
            } else {
                this.mRows = (int)(1.5 + Math.sqrt(this.mWidgetsCount));
                this.mColumns = (this.mWidgetsCount + this.mRows - 1) / this.mRows;
            }
        } else {
            this.mRows = this.mRowsSet;
            this.mColumns = this.mColumnsSet;
        }
    }

    private ConstraintWidget makeNewWidget() {
        ConstraintWidget widget = new ConstraintWidget();
        widget.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        widget.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        widget.stringId = String.valueOf(widget.hashCode());
        return widget;
    }

    private void connectWidget(ConstraintWidget widget, int row, int column, int rowSpan, int columnSpan) {
        widget.mLeft.connect(this.mBoxWidgets[column].mLeft, 0);
        widget.mTop.connect(this.mBoxWidgets[row].mTop, 0);
        widget.mRight.connect(this.mBoxWidgets[column + columnSpan - 1].mRight, 0);
        widget.mBottom.connect(this.mBoxWidgets[row + rowSpan - 1].mBottom, 0);
    }

    private void setBoxWidgetHorizontalChains() {
        int i;
        int maxVal = Math.max(this.mRows, this.mColumns);
        ConstraintWidget widget = this.mBoxWidgets[0];
        float[] columnWeights = this.parseWeights(this.mColumns, this.mColumnWeights);
        if (this.mColumns == 1) {
            this.clearHorizontalAttributes(widget);
            widget.mLeft.connect(this.mLeft, 0);
            widget.mRight.connect(this.mRight, 0);
            return;
        }
        for (i = 0; i < this.mColumns; ++i) {
            widget = this.mBoxWidgets[i];
            this.clearHorizontalAttributes(widget);
            if (columnWeights != null) {
                widget.setHorizontalWeight(columnWeights[i]);
            }
            if (i > 0) {
                widget.mLeft.connect(this.mBoxWidgets[i - 1].mRight, 0);
            } else {
                widget.mLeft.connect(this.mLeft, 0);
            }
            if (i < this.mColumns - 1) {
                widget.mRight.connect(this.mBoxWidgets[i + 1].mLeft, 0);
            } else {
                widget.mRight.connect(this.mRight, 0);
            }
            if (i <= 0) continue;
            widget.mLeft.mMargin = (int)this.mHorizontalGaps;
        }
        for (i = this.mColumns; i < maxVal; ++i) {
            widget = this.mBoxWidgets[i];
            this.clearHorizontalAttributes(widget);
            widget.mLeft.connect(this.mLeft, 0);
            widget.mRight.connect(this.mRight, 0);
        }
    }

    private void setBoxWidgetVerticalChains() {
        int i;
        int maxVal = Math.max(this.mRows, this.mColumns);
        ConstraintWidget widget = this.mBoxWidgets[0];
        float[] rowWeights = this.parseWeights(this.mRows, this.mRowWeights);
        if (this.mRows == 1) {
            this.clearVerticalAttributes(widget);
            widget.mTop.connect(this.mTop, 0);
            widget.mBottom.connect(this.mBottom, 0);
            return;
        }
        for (i = 0; i < this.mRows; ++i) {
            widget = this.mBoxWidgets[i];
            this.clearVerticalAttributes(widget);
            if (rowWeights != null) {
                widget.setVerticalWeight(rowWeights[i]);
            }
            if (i > 0) {
                widget.mTop.connect(this.mBoxWidgets[i - 1].mBottom, 0);
            } else {
                widget.mTop.connect(this.mTop, 0);
            }
            if (i < this.mRows - 1) {
                widget.mBottom.connect(this.mBoxWidgets[i + 1].mTop, 0);
            } else {
                widget.mBottom.connect(this.mBottom, 0);
            }
            if (i <= 0) continue;
            widget.mTop.mMargin = (int)this.mVerticalGaps;
        }
        for (i = this.mRows; i < maxVal; ++i) {
            widget = this.mBoxWidgets[i];
            this.clearVerticalAttributes(widget);
            widget.mTop.connect(this.mTop, 0);
            widget.mBottom.connect(this.mBottom, 0);
        }
    }

    private void addConstraints() {
        this.setBoxWidgetVerticalChains();
        this.setBoxWidgetHorizontalChains();
        this.arrangeWidgets();
    }

    private void createBoxes() {
        int boxCount = Math.max(this.mRows, this.mColumns);
        if (this.mBoxWidgets == null) {
            this.mBoxWidgets = new ConstraintWidget[boxCount];
            for (int i = 0; i < this.mBoxWidgets.length; ++i) {
                this.mBoxWidgets[i] = this.makeNewWidget();
            }
        } else if (boxCount != this.mBoxWidgets.length) {
            ConstraintWidget[] temp = new ConstraintWidget[boxCount];
            for (int i = 0; i < boxCount; ++i) {
                temp[i] = i < this.mBoxWidgets.length ? this.mBoxWidgets[i] : this.makeNewWidget();
            }
            for (int j = boxCount; j < this.mBoxWidgets.length; ++j) {
                ConstraintWidget widget = this.mBoxWidgets[j];
                this.mContainer.remove(widget);
            }
            this.mBoxWidgets = temp;
        }
    }

    private void clearVerticalAttributes(ConstraintWidget widget) {
        widget.setVerticalWeight(-1.0f);
        widget.mTop.reset();
        widget.mBottom.reset();
        widget.mBaseline.reset();
    }

    private void clearHorizontalAttributes(ConstraintWidget widget) {
        widget.setHorizontalWeight(-1.0f);
        widget.mLeft.reset();
        widget.mRight.reset();
    }

    private void initVariables() {
        for (Object[] row : this.mPositionMatrix = new boolean[this.mRows][this.mColumns]) {
            Arrays.fill(row, true);
        }
        if (this.mWidgetsCount > 0) {
            int[][] nArray = this.mConstraintMatrix = new int[this.mWidgetsCount][4];
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] row;
                row = nArray[i];
                Arrays.fill((int[])row, -1);
            }
        }
    }

    private int[][] parseSpans(String str, boolean isSpans) {
        try {
            int extraRows = 0;
            int extraColumns = 0;
            String[] spans = str.split(",");
            int[][] spanMatrix = new int[spans.length][3];
            if (this.mRows == 1 || this.mColumns == 1) {
                for (int i = 0; i < spans.length; ++i) {
                    String[] indexAndSpan = spans[i].trim().split(":");
                    spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
                    spanMatrix[i][1] = 1;
                    spanMatrix[i][2] = 1;
                    if (this.mColumns == 1) {
                        spanMatrix[i][1] = Integer.parseInt(indexAndSpan[1]);
                        extraRows += spanMatrix[i][1];
                        if (isSpans) {
                            --extraRows;
                        }
                    }
                    if (this.mRows != 1) continue;
                    spanMatrix[i][2] = Integer.parseInt(indexAndSpan[1]);
                    extraColumns += spanMatrix[i][2];
                    if (!isSpans) continue;
                    --extraColumns;
                }
                if (extraRows != 0 && !this.mExtraSpaceHandled) {
                    this.setRows(this.mRows + extraRows);
                }
                if (extraColumns != 0 && !this.mExtraSpaceHandled) {
                    this.setColumns(this.mColumns + extraColumns);
                }
                this.mExtraSpaceHandled = true;
            } else {
                for (int i = 0; i < spans.length; ++i) {
                    String[] indexAndSpan = spans[i].trim().split(":");
                    String[] rowAndCol = indexAndSpan[1].split("x");
                    spanMatrix[i][0] = Integer.parseInt(indexAndSpan[0]);
                    if (this.mSubGridByColRow) {
                        spanMatrix[i][1] = Integer.parseInt(rowAndCol[1]);
                        spanMatrix[i][2] = Integer.parseInt(rowAndCol[0]);
                        continue;
                    }
                    spanMatrix[i][1] = Integer.parseInt(rowAndCol[0]);
                    spanMatrix[i][2] = Integer.parseInt(rowAndCol[1]);
                }
            }
            return spanMatrix;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void fillConstraintMatrix(boolean isUpdate) {
        int[][] mSpans;
        int[][] mSkips;
        if (isUpdate) {
            int j;
            int i;
            for (i = 0; i < this.mPositionMatrix.length; ++i) {
                for (j = 0; j < this.mPositionMatrix[0].length; ++j) {
                    this.mPositionMatrix[i][j] = true;
                }
            }
            for (i = 0; i < this.mConstraintMatrix.length; ++i) {
                for (j = 0; j < this.mConstraintMatrix[0].length; ++j) {
                    this.mConstraintMatrix[i][j] = -1;
                }
            }
        }
        this.mNextAvailableIndex = 0;
        if (this.mSkips != null && !this.mSkips.trim().isEmpty() && (mSkips = this.parseSpans(this.mSkips, false)) != null) {
            this.handleSkips(mSkips);
        }
        if (this.mSpans != null && !this.mSpans.trim().isEmpty() && (mSpans = this.parseSpans(this.mSpans, true)) != null) {
            this.handleSpans(mSpans);
        }
    }

    private void initMatrices() {
        boolean isUpdate;
        boolean bl = isUpdate = this.mConstraintMatrix != null && this.mConstraintMatrix.length == this.mWidgetsCount && this.mPositionMatrix != null && this.mPositionMatrix.length == this.mRows && this.mPositionMatrix[0].length == this.mColumns;
        if (!isUpdate) {
            this.initVariables();
        }
        this.fillConstraintMatrix(isUpdate);
    }

    private void handleFlags() {
        if (this.mFlags == null) {
            return;
        }
        block4: for (int flag : this.mFlags) {
            switch (flag) {
                case 1: {
                    this.mSpansRespectWidgetOrder = true;
                    continue block4;
                }
                case 0: {
                    this.mSubGridByColRow = true;
                }
            }
        }
    }

    @Override
    public void measure(int widthMode, int widthSize, int heightMode, int heightSize) {
        super.measure(widthMode, widthSize, heightMode, heightSize);
        this.mContainer = (ConstraintWidgetContainer)this.getParent();
        this.setupGrid(false);
        this.mContainer.add(this.mBoxWidgets);
    }

    @Override
    public void addToSolver(@Nullable LinearSystem system, boolean optimize) {
        super.addToSolver(system, optimize);
        this.addConstraints();
    }
}

