/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;

public class LinearCurveFit
extends CurveFit {
    private static final String TAG = "LinearCurveFit";
    private double[] mT;
    private double[][] mY;
    private double mTotalLength = Double.NaN;
    private boolean mExtrapolate = true;
    double[] mSlopeTemp;

    public LinearCurveFit(double[] time, double[][] y) {
        int dim = y[0].length;
        this.mSlopeTemp = new double[dim];
        this.mT = time;
        this.mY = y;
        if (dim > 2) {
            double sum = 0.0;
            double lastx = 0.0;
            double lasty = 0.0;
            for (int i = 0; i < time.length; ++i) {
                double px = y[i][0];
                double py = y[i][0];
                if (i > 0) {
                    sum += Math.hypot(px - lastx, py - lasty);
                }
                lastx = px;
                lasty = py;
            }
            this.mTotalLength = 0.0;
        }
    }

    private double getLength2D(double t) {
        if (Double.isNaN(this.mTotalLength)) {
            return 0.0;
        }
        int n = this.mT.length;
        if (t <= this.mT[0]) {
            return 0.0;
        }
        if (t >= this.mT[n - 1]) {
            return this.mTotalLength;
        }
        double sum = 0.0;
        double last_x = 0.0;
        double last_y = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double px = this.mY[i][0];
            double py = this.mY[i][1];
            if (i > 0) {
                sum += Math.hypot(px - last_x, py - last_y);
            }
            last_x = px;
            last_y = py;
            if (t == this.mT[i]) {
                return sum;
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double x1 = this.mY[i][0];
            double x2 = this.mY[i + 1][0];
            double y1 = this.mY[i][1];
            double y2 = this.mY[i + 1][1];
            return sum += Math.hypot(py -= y1 * (1.0 - x) + y2 * x, px -= x1 * (1.0 - x) + x2 * x);
        }
        return 0.0;
    }

    @Override
    public void getPos(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j];
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[n - 1][j];
                }
                return;
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                v[j] = y1 * (1.0 - x) + y2 * x;
            }
            return;
        }
    }

    @Override
    public void getPos(double t, float[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                this.getSlope(this.mT[0], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[0][j] + (t - this.mT[0]) * this.mSlopeTemp[j]);
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                this.getSlope(this.mT[n - 1], this.mSlopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)(this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.mSlopeTemp[j]);
                }
                return;
            }
        } else {
            if (t <= this.mT[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[0][j];
                }
                return;
            }
            if (t >= this.mT[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[n - 1][j];
                }
                return;
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i][j];
                }
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                v[j] = (float)(y1 * (1.0 - x) + y2 * x);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (this.mExtrapolate) {
            if (t <= this.mT[0]) {
                return this.mY[0][j] + (t - this.mT[0]) * this.getSlope(this.mT[0], j);
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j] + (t - this.mT[n - 1]) * this.getSlope(this.mT[n - 1], j);
            }
        } else {
            if (t <= this.mT[0]) {
                return this.mY[0][j];
            }
            if (t >= this.mT[n - 1]) {
                return this.mY[n - 1][j];
            }
        }
        for (int i = 0; i < n - 1; ++i) {
            if (t == this.mT[i]) {
                return this.mY[i][j];
            }
            if (!(t < this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double x = (t - this.mT[i]) / h;
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            return y1 * (1.0 - x) + y2 * x;
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i][j];
                double y2 = this.mY[i + 1][j];
                v[j] = (y2 - y1) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        int n = this.mT.length;
        if (t < this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i = 0; i < n - 1; ++i) {
            if (!(t <= this.mT[i + 1])) continue;
            double h = this.mT[i + 1] - this.mT[i];
            double y1 = this.mY[i][j];
            double y2 = this.mY[i + 1][j];
            return (y2 - y1) / h;
        }
        return 0.0;
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }
}

