/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.StopEngine;

public class StopLogicEngine
implements StopEngine {
    private float mStage1Velocity;
    private float mStage2Velocity;
    private float mStage3Velocity;
    private float mStage1Duration;
    private float mStage2Duration;
    private float mStage3Duration;
    private float mStage1EndPosition;
    private float mStage2EndPosition;
    private float mStage3EndPosition;
    private int mNumberOfStages;
    private String mType;
    private boolean mBackwards = false;
    private float mStartPosition;
    private float mLastPosition;
    private float mLastTime;
    private boolean mDone = false;
    private static final float EPSILON = 1.0E-5f;

    @Override
    public String debug(String desc, float time) {
        String ret = desc + " ===== " + this.mType + "\n";
        ret = ret + desc + (this.mBackwards ? "backwards" : "forward ") + " time = " + time + "  stages " + this.mNumberOfStages + "\n";
        ret = ret + desc + " dur " + this.mStage1Duration + " vel " + this.mStage1Velocity + " pos " + this.mStage1EndPosition + "\n";
        if (this.mNumberOfStages > 1) {
            ret = ret + desc + " dur " + this.mStage2Duration + " vel " + this.mStage2Velocity + " pos " + this.mStage2EndPosition + "\n";
        }
        if (this.mNumberOfStages > 2) {
            ret = ret + desc + " dur " + this.mStage3Duration + " vel " + this.mStage3Velocity + " pos " + this.mStage3EndPosition + "\n";
        }
        if (time <= this.mStage1Duration) {
            ret = ret + desc + "stage 0\n";
            return ret;
        }
        if (this.mNumberOfStages == 1) {
            ret = ret + desc + "end stage 0\n";
            return ret;
        }
        if ((time -= this.mStage1Duration) < this.mStage2Duration) {
            ret = ret + desc + " stage 1\n";
            return ret;
        }
        if (this.mNumberOfStages == 2) {
            ret = ret + desc + "end stage 1\n";
            return ret;
        }
        if ((time -= this.mStage2Duration) < this.mStage3Duration) {
            ret = ret + desc + " stage 2\n";
            return ret;
        }
        ret = ret + desc + " end stage 2\n";
        return ret;
    }

    @Override
    public float getVelocity(float x) {
        if (x <= this.mStage1Duration) {
            return this.mStage1Velocity + (this.mStage2Velocity - this.mStage1Velocity) * x / this.mStage1Duration;
        }
        if (this.mNumberOfStages == 1) {
            return 0.0f;
        }
        if ((x -= this.mStage1Duration) < this.mStage2Duration) {
            return this.mStage2Velocity + (this.mStage3Velocity - this.mStage2Velocity) * x / this.mStage2Duration;
        }
        if (this.mNumberOfStages == 2) {
            return 0.0f;
        }
        if ((x -= this.mStage2Duration) < this.mStage3Duration) {
            return this.mStage3Velocity - this.mStage3Velocity * x / this.mStage3Duration;
        }
        return 0.0f;
    }

    private float calcY(float time) {
        this.mDone = false;
        if (time <= this.mStage1Duration) {
            return this.mStage1Velocity * time + (this.mStage2Velocity - this.mStage1Velocity) * time * time / (2.0f * this.mStage1Duration);
        }
        if (this.mNumberOfStages == 1) {
            return this.mStage1EndPosition;
        }
        if ((time -= this.mStage1Duration) < this.mStage2Duration) {
            return this.mStage1EndPosition + this.mStage2Velocity * time + (this.mStage3Velocity - this.mStage2Velocity) * time * time / (2.0f * this.mStage2Duration);
        }
        if (this.mNumberOfStages == 2) {
            return this.mStage2EndPosition;
        }
        if ((time -= this.mStage2Duration) <= this.mStage3Duration) {
            return this.mStage2EndPosition + this.mStage3Velocity * time - this.mStage3Velocity * time * time / (2.0f * this.mStage3Duration);
        }
        this.mDone = true;
        return this.mStage3EndPosition;
    }

    public void config(float currentPos, float destination, float currentVelocity, float maxTime, float maxAcceleration, float maxVelocity) {
        this.mDone = false;
        this.mStartPosition = currentPos;
        boolean bl = this.mBackwards = currentPos > destination;
        if (this.mBackwards) {
            this.setup(-currentVelocity, currentPos - destination, maxAcceleration, maxVelocity, maxTime);
        } else {
            this.setup(currentVelocity, destination - currentPos, maxAcceleration, maxVelocity, maxTime);
        }
    }

    @Override
    public float getInterpolation(float v) {
        float y;
        this.mLastPosition = y = this.calcY(v);
        this.mLastTime = v;
        return this.mBackwards ? this.mStartPosition - y : this.mStartPosition + y;
    }

    @Override
    public float getVelocity() {
        return this.mBackwards ? -this.getVelocity(this.mLastTime) : this.getVelocity(this.mLastTime);
    }

    @Override
    public boolean isStopped() {
        return this.getVelocity() < 1.0E-5f && Math.abs(this.mStage3EndPosition - this.mLastPosition) < 1.0E-5f;
    }

    private void setup(float velocity, float distance, float maxAcceleration, float maxVelocity, float maxTime) {
        this.mDone = false;
        this.mStage3EndPosition = distance;
        if (velocity == 0.0f) {
            velocity = 1.0E-4f;
        }
        float min_time_to_stop = velocity / maxAcceleration;
        float stopDistance = min_time_to_stop * velocity / 2.0f;
        if (velocity < 0.0f) {
            float timeToZeroVelocity = -velocity / maxAcceleration;
            float reversDistanceTraveled = timeToZeroVelocity * velocity / 2.0f;
            float totalDistance = distance - reversDistanceTraveled;
            float peak_v = (float)Math.sqrt(maxAcceleration * totalDistance);
            if (peak_v < maxVelocity) {
                this.mType = "backward accelerate, decelerate";
                this.mNumberOfStages = 2;
                this.mStage1Velocity = velocity;
                this.mStage2Velocity = peak_v;
                this.mStage3Velocity = 0.0f;
                this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
                this.mStage2Duration = peak_v / maxAcceleration;
                this.mStage1EndPosition = (velocity + peak_v) * this.mStage1Duration / 2.0f;
                this.mStage2EndPosition = distance;
                this.mStage3EndPosition = distance;
                return;
            }
            this.mType = "backward accelerate cruse decelerate";
            this.mNumberOfStages = 3;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = maxVelocity;
            this.mStage3Velocity = maxVelocity;
            this.mStage1Duration = (maxVelocity - velocity) / maxAcceleration;
            this.mStage3Duration = maxVelocity / maxAcceleration;
            float accDist = (velocity + maxVelocity) * this.mStage1Duration / 2.0f;
            float decDist = maxVelocity * this.mStage3Duration / 2.0f;
            this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
            this.mStage1EndPosition = accDist;
            this.mStage2EndPosition = distance - decDist;
            this.mStage3EndPosition = distance;
            return;
        }
        if (stopDistance >= distance) {
            this.mType = "hard stop";
            float time = 2.0f * distance / velocity;
            this.mNumberOfStages = 1;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = 0.0f;
            this.mStage1EndPosition = distance;
            this.mStage1Duration = time;
            return;
        }
        float distance_before_break = distance - stopDistance;
        float cruseTime = distance_before_break / velocity;
        if (cruseTime + min_time_to_stop < maxTime) {
            this.mType = "cruse decelerate";
            this.mNumberOfStages = 2;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = velocity;
            this.mStage3Velocity = 0.0f;
            this.mStage1EndPosition = distance_before_break;
            this.mStage2EndPosition = distance;
            this.mStage1Duration = cruseTime;
            this.mStage2Duration = velocity / maxAcceleration;
            return;
        }
        float peak_v = (float)Math.sqrt(maxAcceleration * distance + velocity * velocity / 2.0f);
        this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
        this.mStage2Duration = peak_v / maxAcceleration;
        if (peak_v < maxVelocity) {
            this.mType = "accelerate decelerate";
            this.mNumberOfStages = 2;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = peak_v;
            this.mStage3Velocity = 0.0f;
            this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
            this.mStage2Duration = peak_v / maxAcceleration;
            this.mStage1EndPosition = (velocity + peak_v) * this.mStage1Duration / 2.0f;
            this.mStage2EndPosition = distance;
            return;
        }
        this.mType = "accelerate cruse decelerate";
        this.mNumberOfStages = 3;
        this.mStage1Velocity = velocity;
        this.mStage2Velocity = maxVelocity;
        this.mStage3Velocity = maxVelocity;
        this.mStage1Duration = (maxVelocity - velocity) / maxAcceleration;
        this.mStage3Duration = maxVelocity / maxAcceleration;
        float accDist = (velocity + maxVelocity) * this.mStage1Duration / 2.0f;
        float decDist = maxVelocity * this.mStage3Duration / 2.0f;
        this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
        this.mStage1EndPosition = accDist;
        this.mStage2EndPosition = distance - decDist;
        this.mStage3EndPosition = distance;
    }

    public static class Decelerate
    implements StopEngine {
        private float mDestination;
        private float mInitialVelocity;
        private float mAcceleration;
        private float mLastVelocity;
        private float mDuration;
        private float mInitialPos;
        private boolean mDone = false;

        @Override
        public String debug(String desc, float time) {
            return this.mDuration + " " + this.mLastVelocity;
        }

        @Override
        public float getVelocity(float time) {
            if (time > this.mDuration) {
                return 0.0f;
            }
            this.mLastVelocity = this.mInitialVelocity + this.mAcceleration * time;
            return this.mLastVelocity;
        }

        @Override
        public float getInterpolation(float time) {
            if (time > this.mDuration) {
                this.mDone = true;
                return this.mDestination;
            }
            this.getVelocity(time);
            return this.mInitialPos + (this.mInitialVelocity + this.mAcceleration * time / 2.0f) * time;
        }

        @Override
        public float getVelocity() {
            return this.mLastVelocity;
        }

        @Override
        public boolean isStopped() {
            return this.mDone;
        }

        public void config(float currentPos, float destination, float currentVelocity) {
            this.mDone = false;
            this.mDestination = destination;
            this.mInitialVelocity = currentVelocity;
            this.mInitialPos = currentPos;
            float distance = this.mDestination - currentPos;
            this.mDuration = distance / (currentVelocity / 2.0f);
            this.mAcceleration = -currentVelocity / this.mDuration;
        }
    }
}

