/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLElement;

public class CLNumber
extends CLElement {
    float mValue = Float.NaN;

    public CLNumber(char[] content) {
        super(content);
    }

    public CLNumber(float value) {
        super(null);
        this.mValue = value;
    }

    public static CLElement allocate(char[] content) {
        return new CLNumber(content);
    }

    @Override
    protected String toJSON() {
        float value = this.getFloat();
        int intValue = (int)value;
        if ((float)intValue == value) {
            return "" + intValue;
        }
        return "" + value;
    }

    @Override
    protected String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder();
        this.addIndent(json, indent);
        float value = this.getFloat();
        int intValue = (int)value;
        if ((float)intValue == value) {
            json.append(intValue);
        } else {
            json.append(value);
        }
        return json.toString();
    }

    public boolean isInt() {
        float value = this.getFloat();
        int intValue = (int)value;
        return (float)intValue == value;
    }

    @Override
    public int getInt() {
        if (Float.isNaN(this.mValue) && this.hasContent()) {
            this.mValue = Integer.parseInt(this.content());
        }
        return (int)this.mValue;
    }

    @Override
    public float getFloat() {
        if (Float.isNaN(this.mValue) && this.hasContent()) {
            this.mValue = Float.parseFloat(this.content());
        }
        return this.mValue;
    }

    public void putValue(float value) {
        this.mValue = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CLNumber) {
            float thisFloat = this.getFloat();
            float otherFloat = ((CLNumber)obj).getFloat();
            if (Float.isNaN(thisFloat) && Float.isNaN(otherFloat)) {
                return true;
            }
            return thisFloat == otherFloat;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mValue != 0.0f ? Float.floatToIntBits(this.mValue) : 0);
        return result;
    }
}

