/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.LinearSystem;
import java.util.Arrays;
import java.util.HashSet;

public class SolverVariable
implements Comparable<SolverVariable> {
    private static final boolean INTERNAL_DEBUG = false;
    private static final boolean VAR_USE_HASH = false;
    private static final boolean DO_NOT_USE = false;
    public static final int STRENGTH_NONE = 0;
    public static final int STRENGTH_LOW = 1;
    public static final int STRENGTH_MEDIUM = 2;
    public static final int STRENGTH_HIGH = 3;
    public static final int STRENGTH_HIGHEST = 4;
    public static final int STRENGTH_EQUALITY = 5;
    public static final int STRENGTH_BARRIER = 6;
    public static final int STRENGTH_CENTERING = 7;
    public static final int STRENGTH_FIXED = 8;
    private static int sUniqueSlackId = 1;
    private static int sUniqueErrorId = 1;
    private static int sUniqueUnrestrictedId = 1;
    private static int sUniqueConstantId = 1;
    private static int sUniqueId = 1;
    public boolean inGoal;
    private String mName;
    public int id = -1;
    int mDefinitionId = -1;
    public int strength = 0;
    public float computedValue;
    public boolean isFinalValue = false;
    static final int MAX_STRENGTH = 9;
    float[] mStrengthVector = new float[9];
    float[] mGoalStrengthVector = new float[9];
    Type mType;
    ArrayRow[] mClientEquations = new ArrayRow[16];
    int mClientEquationsCount = 0;
    public int usageInRowCount = 0;
    boolean mIsSynonym = false;
    int mSynonym = -1;
    float mSynonymDelta = 0.0f;
    HashSet<ArrayRow> mInRows = null;

    static void increaseErrorId() {
        ++sUniqueErrorId;
    }

    private static String getUniqueName(Type type, String prefix) {
        if (prefix != null) {
            return prefix + sUniqueErrorId;
        }
        switch (type.ordinal()) {
            case 0: {
                return "U" + ++sUniqueUnrestrictedId;
            }
            case 1: {
                return "C" + ++sUniqueConstantId;
            }
            case 2: {
                return "S" + ++sUniqueSlackId;
            }
            case 3: {
                return "e" + ++sUniqueErrorId;
            }
            case 4: {
                return "V" + ++sUniqueId;
            }
        }
        throw new AssertionError((Object)type.name());
    }

    public SolverVariable(String name, Type type) {
        this.mName = name;
        this.mType = type;
    }

    public SolverVariable(Type type, String prefix) {
        this.mType = type;
    }

    void clearStrengths() {
        for (int i = 0; i < 9; ++i) {
            this.mStrengthVector[i] = 0.0f;
        }
    }

    String strengthsToString() {
        String representation = this + "[";
        boolean negative = false;
        boolean empty = true;
        for (int j = 0; j < this.mStrengthVector.length; ++j) {
            representation = representation + this.mStrengthVector[j];
            if (this.mStrengthVector[j] > 0.0f) {
                negative = false;
            } else if (this.mStrengthVector[j] < 0.0f) {
                negative = true;
            }
            if (this.mStrengthVector[j] != 0.0f) {
                empty = false;
            }
            representation = j < this.mStrengthVector.length - 1 ? representation + ", " : representation + "] ";
        }
        if (negative) {
            representation = representation + " (-)";
        }
        if (empty) {
            representation = representation + " (*)";
        }
        return representation;
    }

    public final void addToRow(ArrayRow row) {
        for (int i = 0; i < this.mClientEquationsCount; ++i) {
            if (this.mClientEquations[i] != row) continue;
            return;
        }
        if (this.mClientEquationsCount >= this.mClientEquations.length) {
            this.mClientEquations = Arrays.copyOf(this.mClientEquations, this.mClientEquations.length * 2);
        }
        this.mClientEquations[this.mClientEquationsCount] = row;
        ++this.mClientEquationsCount;
    }

    public final void removeFromRow(ArrayRow row) {
        int count = this.mClientEquationsCount;
        for (int i = 0; i < count; ++i) {
            if (this.mClientEquations[i] != row) continue;
            for (int j = i; j < count - 1; ++j) {
                this.mClientEquations[j] = this.mClientEquations[j + 1];
            }
            --this.mClientEquationsCount;
            return;
        }
    }

    public final void updateReferencesWithNewDefinition(LinearSystem system, ArrayRow definition) {
        int count = this.mClientEquationsCount;
        for (int i = 0; i < count; ++i) {
            this.mClientEquations[i].updateFromRow(system, definition, false);
        }
        this.mClientEquationsCount = 0;
    }

    public void setFinalValue(LinearSystem system, float value) {
        this.computedValue = value;
        this.isFinalValue = true;
        this.mIsSynonym = false;
        this.mSynonym = -1;
        this.mSynonymDelta = 0.0f;
        int count = this.mClientEquationsCount;
        this.mDefinitionId = -1;
        for (int i = 0; i < count; ++i) {
            this.mClientEquations[i].updateFromFinalVariable(system, this, false);
        }
        this.mClientEquationsCount = 0;
    }

    public void setSynonym(LinearSystem system, SolverVariable synonymVariable, float value) {
        this.mIsSynonym = true;
        this.mSynonym = synonymVariable.id;
        this.mSynonymDelta = value;
        int count = this.mClientEquationsCount;
        this.mDefinitionId = -1;
        for (int i = 0; i < count; ++i) {
            this.mClientEquations[i].updateFromSynonymVariable(system, this, false);
        }
        this.mClientEquationsCount = 0;
        system.displayReadableRows();
    }

    public void reset() {
        this.mName = null;
        this.mType = Type.UNKNOWN;
        this.strength = 0;
        this.id = -1;
        this.mDefinitionId = -1;
        this.computedValue = 0.0f;
        this.isFinalValue = false;
        this.mIsSynonym = false;
        this.mSynonym = -1;
        this.mSynonymDelta = 0.0f;
        int count = this.mClientEquationsCount;
        for (int i = 0; i < count; ++i) {
            this.mClientEquations[i] = null;
        }
        this.mClientEquationsCount = 0;
        this.usageInRowCount = 0;
        this.inGoal = false;
        Arrays.fill(this.mGoalStrengthVector, 0.0f);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setType(Type type, String prefix) {
        this.mType = type;
    }

    @Override
    public int compareTo(SolverVariable v) {
        return this.id - v.id;
    }

    public String toString() {
        String result = "";
        result = this.mName != null ? result + this.mName : result + this.id;
        return result;
    }

    public static enum Type {
        UNRESTRICTED,
        CONSTANT,
        SLACK,
        ERROR,
        UNKNOWN;

    }
}

