/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.State;
import java.util.HashMap;

public class ChainReference
extends HelperReference {
    protected float mBias = 0.5f;
    @Deprecated
    @NonNull
    protected HashMap<String, Float> mMapWeights = new HashMap();
    @Deprecated
    @NonNull
    protected HashMap<String, Float> mMapPreMargin = new HashMap();
    @Deprecated
    @NonNull
    protected HashMap<String, Float> mMapPostMargin = new HashMap();
    private HashMap<String, Float> mMapPreGoneMargin;
    private HashMap<String, Float> mMapPostGoneMargin;
    @NonNull
    protected State.Chain mStyle = State.Chain.SPREAD;

    public ChainReference(@NonNull State state, @NonNull State.Helper type) {
        super(state, type);
    }

    @NonNull
    public State.Chain getStyle() {
        return State.Chain.SPREAD;
    }

    @NonNull
    public ChainReference style(@NonNull State.Chain style) {
        this.mStyle = style;
        return this;
    }

    public void addChainElement(@NonNull String id, float weight, float preMargin, float postMargin) {
        this.addChainElement(id, weight, preMargin, postMargin, 0.0f, 0.0f);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addChainElement(@NonNull Object id, float weight, float preMargin, float postMargin, float preGoneMargin, float postGoneMargin) {
        super.add(id);
        String idString = id.toString();
        if (!Float.isNaN(weight)) {
            this.mMapWeights.put(idString, Float.valueOf(weight));
        }
        if (!Float.isNaN(preMargin)) {
            this.mMapPreMargin.put(idString, Float.valueOf(preMargin));
        }
        if (!Float.isNaN(postMargin)) {
            this.mMapPostMargin.put(idString, Float.valueOf(postMargin));
        }
        if (!Float.isNaN(preGoneMargin)) {
            if (this.mMapPreGoneMargin == null) {
                this.mMapPreGoneMargin = new HashMap();
            }
            this.mMapPreGoneMargin.put(idString, Float.valueOf(preGoneMargin));
        }
        if (!Float.isNaN(postGoneMargin)) {
            if (this.mMapPostGoneMargin == null) {
                this.mMapPostGoneMargin = new HashMap();
            }
            this.mMapPostGoneMargin.put(idString, Float.valueOf(postGoneMargin));
        }
    }

    protected float getWeight(@NonNull String id) {
        if (this.mMapWeights.containsKey(id)) {
            return this.mMapWeights.get(id).floatValue();
        }
        return -1.0f;
    }

    protected float getPostMargin(@NonNull String id) {
        if (this.mMapPostMargin.containsKey(id)) {
            return this.mMapPostMargin.get(id).floatValue();
        }
        return 0.0f;
    }

    protected float getPreMargin(@NonNull String id) {
        if (this.mMapPreMargin.containsKey(id)) {
            return this.mMapPreMargin.get(id).floatValue();
        }
        return 0.0f;
    }

    float getPostGoneMargin(@NonNull String id) {
        if (this.mMapPostGoneMargin != null && this.mMapPostGoneMargin.containsKey(id)) {
            return this.mMapPostGoneMargin.get(id).floatValue();
        }
        return 0.0f;
    }

    float getPreGoneMargin(@NonNull String id) {
        if (this.mMapPreGoneMargin != null && this.mMapPreGoneMargin.containsKey(id)) {
            return this.mMapPreGoneMargin.get(id).floatValue();
        }
        return 0.0f;
    }

    public float getBias() {
        return this.mBias;
    }

    @Override
    @NonNull
    public ChainReference bias(float bias) {
        this.mBias = bias;
        return this;
    }
}

