/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.SolverVariable;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.HelperWidget;
import java.util.HashMap;

public class Barrier
extends HelperWidget {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int mBarrierType = 0;
    private boolean mAllowsGoneWidget = true;
    private int mMargin = 0;

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    public int getBarrierType() {
        return this.mBarrierType;
    }

    public void setBarrierType(int barrierType) {
        this.mBarrierType = barrierType;
    }

    public void setAllowsGoneWidget(boolean allowsGoneWidget) {
        this.mAllowsGoneWidget = allowsGoneWidget;
    }

    public boolean allowsGoneWidget() {
        return this.mAllowsGoneWidget;
    }

    @Override
    public void copy(ConstraintWidget src, HashMap<ConstraintWidget, ConstraintWidget> map) {
        super.copy(src, map);
        Barrier srcBarrier = (Barrier)src;
        this.mBarrierType = srcBarrier.mBarrierType;
        this.mAllowsGoneWidget = srcBarrier.mAllowsGoneWidget;
        this.mMargin = srcBarrier.mMargin;
    }

    @Override
    public void addToSolver(LinearSystem system) {
        ConstraintWidget widget;
        int i;
        this.mListAnchors[0] = this.mLeft;
        this.mListAnchors[2] = this.mTop;
        this.mListAnchors[1] = this.mRight;
        this.mListAnchors[3] = this.mBottom;
        for (int i2 = 0; i2 < this.mListAnchors.length; ++i2) {
            this.mListAnchors[i2].mSolverVariable = system.createObjectVariable(this.mListAnchors[i2]);
        }
        if (this.mBarrierType < 0 || this.mBarrierType >= 4) {
            return;
        }
        ConstraintAnchor position = this.mListAnchors[this.mBarrierType];
        boolean hasMatchConstraintWidgets = false;
        for (i = 0; i < this.mWidgetsCount; ++i) {
            widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            if ((this.mBarrierType == 0 || this.mBarrierType == 1) && widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                hasMatchConstraintWidgets = true;
                break;
            }
            if (this.mBarrierType != 2 && this.mBarrierType != 3 || widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            hasMatchConstraintWidgets = true;
            break;
        }
        if (this.mBarrierType == 0 || this.mBarrierType == 1) {
            if (this.getParent().getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                hasMatchConstraintWidgets = false;
            }
        } else if (this.getParent().getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            hasMatchConstraintWidgets = false;
        }
        for (i = 0; i < this.mWidgetsCount; ++i) {
            SolverVariable target;
            widget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !widget.allowedInBarrier()) continue;
            widget.mListAnchors[this.mBarrierType].mSolverVariable = target = system.createObjectVariable(widget.mListAnchors[this.mBarrierType]);
            if (this.mBarrierType == 0 || this.mBarrierType == 2) {
                system.addLowerBarrier(position.mSolverVariable, target, this.mMargin, hasMatchConstraintWidgets);
                continue;
            }
            system.addGreaterBarrier(position.mSolverVariable, target, this.mMargin, hasMatchConstraintWidgets);
        }
        if (this.mBarrierType == 0) {
            system.addEquality(this.mRight.mSolverVariable, this.mLeft.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mLeft.mSolverVariable, this.mParent.mRight.mSolverVariable, 0, 4);
            }
        } else if (this.mBarrierType == 1) {
            system.addEquality(this.mLeft.mSolverVariable, this.mRight.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mLeft.mSolverVariable, this.mParent.mLeft.mSolverVariable, 0, 4);
            }
        } else if (this.mBarrierType == 2) {
            system.addEquality(this.mBottom.mSolverVariable, this.mTop.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mTop.mSolverVariable, this.mParent.mBottom.mSolverVariable, 0, 4);
            }
        } else if (this.mBarrierType == 3) {
            system.addEquality(this.mTop.mSolverVariable, this.mBottom.mSolverVariable, 0, 6);
            if (!hasMatchConstraintWidgets) {
                system.addEquality(this.mTop.mSolverVariable, this.mParent.mTop.mSolverVariable, 0, 4);
            }
        }
    }

    public void setMargin(int margin) {
        this.mMargin = margin;
    }

    public int getMargin() {
        return this.mMargin;
    }
}

