/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.MethodCallExpr;
import android.databinding.tool.expr.TernaryExpr;
import android.databinding.tool.expr.VersionProvider;
import android.databinding.tool.processing.ErrorMessages;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Expr
implements VersionProvider,
LocationScopeProvider {
    public static final int NO_ID = -1;
    protected List<Expr> mChildren = new ArrayList<Expr>();
    private List<Expr> mParents = new ArrayList<Expr>();
    private Boolean mIsDynamic;
    private ModelClass mResolvedType;
    private String mUniqueKey;
    private List<Dependency> mDependencies;
    private List<Dependency> mDependants = new ArrayList<Dependency>();
    private int mId = -1;
    private int mRequirementId = -1;
    private int mVersion = 0;
    private boolean mCanBeInvalidated = false;
    private boolean mUnboxedAChild = false;
    @Nullable
    private List<Location> mLocations = new ArrayList<Location>();
    private BitSet mInvalidFlags;
    private ExprModel mModel;
    BitSet mShouldReadFlags;
    BitSet mReadSoFar = new BitSet();
    BitSet mShouldReadWithConditionals;
    private boolean mIsBindingExpression = false;
    private boolean mRead;
    private boolean mIsUsed = false;
    private boolean mIsUsedInCallback = false;
    private boolean mUnwrapObservableFields = true;
    protected static final String KEY_JOIN = "~";
    protected static final String KEY_JOIN_START = "(";
    protected static final String KEY_JOIN_END = ")";
    protected static final String KEY_START = "@";
    protected static final String KEY_END = "#";
    BitSet mConditionalFlags;
    private Node mCalculationPaths = null;

    Expr(Iterable<Expr> children) {
        for (Expr expr : children) {
            this.mChildren.add(expr);
        }
        this.addParents();
    }

    Expr(Expr ... children) {
        Collections.addAll(this.mChildren, children);
        this.addParents();
    }

    public int getId() {
        Preconditions.check((this.mId != -1 ? 1 : 0) != 0, (String)"if getId is called on an expression, it should have an id: %s", (Object[])new Object[]{this});
        return this.mId;
    }

    public void setId(int id) {
        Preconditions.check((this.mId == -1 ? 1 : 0) != 0, (String)"ID is already set on %s", (Object[])new Object[]{this});
        this.mId = id;
    }

    public void addLocation(Location location) {
        this.mLocations.add(location);
    }

    public List<Location> getLocations() {
        return this.mLocations;
    }

    public ExprModel getModel() {
        return this.mModel;
    }

    public BitSet getInvalidFlags() {
        if (this.mInvalidFlags == null) {
            this.mInvalidFlags = this.resolveInvalidFlags();
        }
        return this.mInvalidFlags;
    }

    private BitSet resolveInvalidFlags() {
        BitSet bitSet = (BitSet)this.mModel.getInvalidateAnyBitSet().clone();
        if (this.mCanBeInvalidated) {
            bitSet.set(this.getId(), true);
        }
        for (Dependency dependency : this.getDependencies()) {
            bitSet.or(dependency.getOther().getInvalidFlags());
        }
        return bitSet;
    }

    public void markAsBindingExpression() {
        this.mIsBindingExpression = true;
    }

    public boolean isBindingExpression() {
        return this.mIsBindingExpression;
    }

    public boolean canBeEvaluatedToAVariable() {
        return true;
    }

    public boolean isObservable() {
        return this.getResolvedType().isObservable();
    }

    public String getUpdateRegistrationCall() {
        if (!this.isObservable()) {
            L.e((String)"The expression isn't observable!", (Object[])new Object[0]);
        }
        if (this.getResolvedType().isLiveData()) {
            return "updateLiveDataRegistration";
        }
        return "updateRegistration";
    }

    public void setUnwrapObservableFields(boolean unwrapObservableFields) {
        this.mUnwrapObservableFields = unwrapObservableFields;
    }

    public Expr resolveListeners(ModelClass valueType, Expr parent) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Expr child = this.mChildren.get(i);
            child.resolveListeners(valueType, this);
        }
        this.resetResolvedType();
        return this;
    }

    public void safeUnboxChild(ExprModel model, Expr child) {
        if (child.getResolvedType().unbox() == child.getResolvedType()) {
            return;
        }
        this.mUnboxedAChild = true;
        L.w((String)ErrorMessages.BOXED_VALUE_CASTING, (Object[])new Object[]{child, this, child});
        int index = this.getChildren().indexOf(child);
        child.getParents().remove(this);
        this.getChildren().set(index, model.safeUnbox(child));
    }

    public Expr resolveTwoWayExpressions(Expr parent) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            Expr child = this.mChildren.get(i);
            child.resolveTwoWayExpressions(this);
        }
        return this;
    }

    protected void resetResolvedType() {
        this.mResolvedType = null;
    }

    public BitSet getShouldReadFlags() {
        if (this.mShouldReadFlags == null) {
            this.getShouldReadFlagsWithConditionals();
            this.mShouldReadFlags = this.resolveShouldReadFlags();
        }
        return this.mShouldReadFlags;
    }

    public BitSet getShouldReadFlagsWithConditionals() {
        if (this.mShouldReadWithConditionals == null) {
            this.mShouldReadWithConditionals = this.resolveShouldReadWithConditionals();
        }
        return this.mShouldReadWithConditionals;
    }

    public void setModel(ExprModel model) {
        this.mModel = model;
    }

    private BitSet resolveShouldReadWithConditionals() {
        BitSet bitSet = new BitSet();
        if (this.isBindingExpression()) {
            bitSet.or(this.getInvalidFlags());
        }
        for (Dependency dependency : this.getDependants()) {
            if (dependency.getCondition() == null) {
                bitSet.or(dependency.getDependant().getShouldReadFlagsWithConditionals());
                continue;
            }
            bitSet.set(dependency.getDependant().getRequirementFlagIndex(dependency.getExpectedOutput()));
        }
        return bitSet;
    }

    private BitSet resolveShouldReadFlags() {
        BitSet bitSet = new BitSet();
        if (this.isRead()) {
            return bitSet;
        }
        if (this.isBindingExpression()) {
            bitSet.or(this.getInvalidFlags());
        }
        for (Dependency dependency : this.getDependants()) {
            boolean isUnreadElevated = Expr.isUnreadElevated(dependency);
            if (dependency.isConditional()) continue;
            if (isUnreadElevated) {
                bitSet.set(dependency.getDependant().getRequirementFlagIndex(dependency.getExpectedOutput()));
                continue;
            }
            bitSet.or(dependency.getDependant().getShouldReadFlags());
        }
        bitSet.and(this.mShouldReadWithConditionals);
        bitSet.andNot(this.mReadSoFar);
        return bitSet;
    }

    private static boolean isUnreadElevated(Dependency input) {
        return input.isElevated() && !input.getDependant().isRead();
    }

    private void addParents() {
        for (Expr expr : this.mChildren) {
            expr.mParents.add(this);
        }
    }

    public void onSwappedWith(Expr existing) {
        for (Expr child : this.mChildren) {
            child.onParentSwapped(this, existing);
        }
    }

    private void onParentSwapped(Expr oldParent, Expr newParent) {
        Preconditions.check((boolean)this.mParents.remove(oldParent), (String)"trying to remove non-existent parent %s from %s", (Object[])new Object[]{oldParent, this.mParents});
        this.mParents.add(newParent);
    }

    public List<Expr> getChildren() {
        return this.mChildren;
    }

    public List<Expr> getParents() {
        return this.mParents;
    }

    public boolean isDynamic() {
        if (this.mIsDynamic == null) {
            this.mIsDynamic = this.isAnyChildDynamic();
        }
        return this.mIsDynamic;
    }

    private boolean isAnyChildDynamic() {
        for (Expr expr : this.mChildren) {
            if (!expr.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public final ModelClass getResolvedType() {
        if (this.mResolvedType == null) {
            if (this.mUnwrapObservableFields) {
                this.unwrapObservableFieldChildren();
                this.mUnwrapObservableFields = false;
            }
            try {
                Scope.enter((ScopeProvider)this);
                this.mResolvedType = this.resolveType(ModelAnalyzer.getInstance());
                if (this.mResolvedType == null) {
                    L.e((String)"Cannot resolve type for %s", (Object[])new Object[]{this});
                }
            }
            finally {
                Scope.exit();
            }
        }
        return this.mResolvedType;
    }

    public final List<ExecutionPath> toExecutionPath(ExecutionPath path) {
        ArrayList<ExecutionPath> paths = new ArrayList<ExecutionPath>();
        paths.add(path);
        return this.toExecutionPath(paths);
    }

    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        if (this.getChildren().isEmpty()) {
            return this.addJustMeToExecutionPath(paths);
        }
        return this.toExecutionPathInOrder(paths, this.getChildren());
    }

    @NotNull
    protected final List<ExecutionPath> addJustMeToExecutionPath(List<ExecutionPath> paths) {
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        for (ExecutionPath path : paths) {
            result.add(path.addPath(this));
        }
        return result;
    }

    protected final List<ExecutionPath> toExecutionPathInOrder(List<ExecutionPath> paths, Expr ... order) {
        List<ExecutionPath> executionPaths = paths;
        for (Expr anOrder : order) {
            executionPaths = anOrder.toExecutionPath(executionPaths);
        }
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>(paths.size());
        for (ExecutionPath path : executionPaths) {
            result.add(path.addPath(this));
        }
        return result;
    }

    protected final List<ExecutionPath> toExecutionPathInOrder(List<ExecutionPath> paths, List<Expr> order) {
        List<ExecutionPath> executionPaths = paths;
        for (Expr expr : order) {
            executionPaths = expr.toExecutionPath(executionPaths);
        }
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>(paths.size());
        for (ExecutionPath path : executionPaths) {
            result.add(path.addPath(this));
        }
        return result;
    }

    protected abstract ModelClass resolveType(ModelAnalyzer var1);

    protected abstract List<Dependency> constructDependencies();

    protected List<Dependency> constructDynamicChildrenDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Expr node : this.mChildren) {
            if (!node.isDynamic()) continue;
            dependencies.add(new Dependency(this, node));
        }
        return dependencies;
    }

    public final List<Dependency> getDependencies() {
        if (this.mDependencies == null) {
            this.mDependencies = this.constructDependencies();
        }
        return this.mDependencies;
    }

    void addDependant(Dependency dependency) {
        this.mDependants.add(dependency);
    }

    public List<Dependency> getDependants() {
        return this.mDependants;
    }

    public final String getUniqueKey() {
        if (this.mUniqueKey == null) {
            String uniqueKey = this.computeUniqueKey();
            Preconditions.checkNotNull((Object)uniqueKey, (String)"you must override computeUniqueKey to return non-null String", (Object[])new Object[0]);
            Preconditions.check((!uniqueKey.trim().isEmpty() ? 1 : 0) != 0, (String)"you must override computeUniqueKey to return a non-empty String", (Object[])new Object[0]);
            this.mUniqueKey = KEY_START + uniqueKey + KEY_END;
        }
        return this.mUniqueKey;
    }

    protected abstract String computeUniqueKey();

    public void enableDirectInvalidation() {
        this.mCanBeInvalidated = true;
    }

    public boolean canBeInvalidated() {
        return this.mCanBeInvalidated;
    }

    public void trimShouldReadFlags(BitSet bitSet) {
        this.mShouldReadFlags.andNot(bitSet);
    }

    public boolean isConditional() {
        return false;
    }

    public int getRequirementId() {
        return this.mRequirementId;
    }

    public void setRequirementId(int requirementId) {
        this.mRequirementId = requirementId;
    }

    public int getRequirementFlagIndex(boolean expectedOutput) {
        Preconditions.check((this.mRequirementId != -1 ? 1 : 0) != 0, (String)"If this is an expression w/ conditional dependencies, it must be assigned a requirement ID. %s", (Object[])new Object[]{this});
        return expectedOutput ? this.mRequirementId + 1 : this.mRequirementId;
    }

    public boolean hasId() {
        return this.mId != -1;
    }

    public void markFlagsAsRead(BitSet flags) {
        this.mReadSoFar.or(flags);
    }

    public boolean isRead() {
        return this.mRead;
    }

    public boolean considerElevatingConditionals(Expr justRead) {
        boolean elevated = false;
        for (Dependency dependency : this.mDependencies) {
            if (!dependency.isConditional() || dependency.getCondition() != justRead) continue;
            dependency.elevate();
            elevated = true;
        }
        return elevated;
    }

    public void invalidateReadFlags() {
        this.mShouldReadFlags = null;
        ++this.mVersion;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean hasNestedCannotRead() {
        if (this.isRead()) {
            return false;
        }
        if (this.getShouldReadFlags().isEmpty()) {
            return true;
        }
        for (Dependency dependency : this.getDependencies()) {
            if (!Expr.hasNestedCannotRead(dependency)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNestedCannotRead(Dependency input) {
        return input.isConditional() || input.getOther().hasNestedCannotRead();
    }

    public boolean markAsReadIfDone() {
        if (this.mRead) {
            return false;
        }
        BitSet clone = (BitSet)this.mShouldReadWithConditionals.clone();
        clone.andNot(this.mReadSoFar);
        this.mRead = clone.isEmpty();
        if (!this.mRead && !this.mReadSoFar.isEmpty()) {
            boolean allCovered = true;
            int i = clone.nextSetBit(0);
            while (i != -1) {
                Expr expr = this.mModel.findFlagExpression(i);
                if (expr != null) {
                    if (!expr.isConditional()) {
                        allCovered = false;
                        break;
                    }
                    BitSet readForConditional = (BitSet)expr.getShouldReadFlagsWithConditionals().clone();
                    readForConditional.andNot(this.mReadSoFar);
                    if (!readForConditional.isEmpty()) {
                        allCovered = false;
                        break;
                    }
                }
                i = clone.nextSetBit(i + 1);
            }
            this.mRead = allCovered;
        }
        if (this.mRead) {
            this.mShouldReadFlags = null;
        }
        return this.mRead;
    }

    private BitSet findConditionalFlags() {
        Preconditions.check((boolean)this.isConditional(), (String)"should not call this on a non-conditional expr", (Object[])new Object[0]);
        if (this.mConditionalFlags == null) {
            this.mConditionalFlags = new BitSet();
            this.resolveConditionalFlags(this.mConditionalFlags);
        }
        return this.mConditionalFlags;
    }

    private void resolveConditionalFlags(BitSet flags) {
        Dependency dependency;
        flags.or(this.getPredicateInvalidFlags());
        if (this.getDependants().size() == 1 && (dependency = this.getDependants().get(0)).getCondition() != null) {
            flags.or(dependency.getDependant().findConditionalFlags());
            flags.set(dependency.getDependant().getRequirementFlagIndex(dependency.getExpectedOutput()));
        }
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ":" + this.getUniqueKey() + "]";
    }

    public BitSet getReadSoFar() {
        return this.mReadSoFar;
    }

    protected Node getAllCalculationPaths() {
        if (this.mCalculationPaths == null) {
            Node node = new Node();
            if (this.isConditional()) {
                node.mBitSet.or(this.getPredicateInvalidFlags());
            } else {
                node.mBitSet.or(this.getInvalidFlags());
            }
            for (Dependency dependency : this.getDependants()) {
                Expr dependant = dependency.getDependant();
                if (dependency.getCondition() != null) {
                    Node cond = new Node();
                    cond.setConditionFlag(dependant.getRequirementFlagIndex(dependency.getExpectedOutput()));
                    cond.mParents.add(dependant.getAllCalculationPaths());
                    node.mParents.add(cond);
                    continue;
                }
                node.mParents.add(dependant.getAllCalculationPaths());
            }
            this.mCalculationPaths = node;
        }
        return this.mCalculationPaths;
    }

    public String getDefaultValue() {
        return ModelAnalyzer.getInstance().getDefaultValue(this.getResolvedType().toJavaCode());
    }

    protected BitSet getPredicateInvalidFlags() {
        throw new IllegalStateException("must override getPredicateInvalidFlags in " + this.getClass().getSimpleName());
    }

    public boolean shouldReadNow(List<Expr> justRead) {
        if (this.getShouldReadFlags().isEmpty()) {
            return false;
        }
        for (Dependency input : this.getDependencies()) {
            boolean dependencyReady = input.getOther().isRead() || justRead != null && justRead.contains(input.getOther());
            if (dependencyReady) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualityCheck() {
        return false;
    }

    public void markAsUsed() {
        this.mIsUsed = true;
        for (Expr child : this.getChildren()) {
            child.markAsUsed();
        }
    }

    public void markAsUsedInCallback() {
        this.mIsUsedInCallback = true;
        for (Expr child : this.getChildren()) {
            child.markAsUsedInCallback();
        }
    }

    public boolean isIsUsedInCallback() {
        return this.mIsUsedInCallback;
    }

    public boolean isUsed() {
        return this.mIsUsed;
    }

    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        Map<String, Expr> exprMap = this.mModel.getExprMap();
        for (int i = this.mParents.size() - 1; i >= 0; --i) {
            Expr parent = this.mParents.get(i);
            if (exprMap.get(parent.getUniqueKey()) == parent) continue;
            this.mParents.remove(i);
        }
        for (Expr child : this.mChildren) {
            child.updateExpr(modelAnalyzer);
        }
    }

    protected static String join(List<?> vals) {
        if (vals == null || vals.isEmpty()) {
            return "";
        }
        return Expr.join(vals.stream());
    }

    protected static String join(Object ... vals) {
        if (vals == null || vals.length == 0) {
            return "";
        }
        return Expr.join(Arrays.stream(vals));
    }

    private static String join(Stream<?> vals) {
        return vals.map(val -> val instanceof Expr ? ((Expr)val).getUniqueKey() : val.toString()).collect(Collectors.joining(KEY_JOIN, KEY_JOIN_START, KEY_JOIN_END));
    }

    protected String asPackage() {
        return null;
    }

    public List<Location> provideScopeLocation() {
        return this.mLocations;
    }

    public KCode toCode() {
        if (this.isDynamic()) {
            return new KCode(LayoutBinderWriterKt.scopedName(this));
        }
        return this.generateCode();
    }

    public KCode toFullCode() {
        return this.generateCode();
    }

    protected abstract KCode generateCode();

    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        throw new IllegalStateException("expression does not support two-way binding");
    }

    public abstract Expr cloneToModel(ExprModel var1);

    protected static List<Expr> cloneToModel(ExprModel model, List<Expr> exprs) {
        ArrayList<Expr> clones = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            clones.add(expr.cloneToModel(model));
        }
        return clones;
    }

    public void assertIsInvertible() {
        String errorMessage = this.getInvertibleError();
        if (errorMessage != null) {
            L.e((String)"The expression %s cannot be inverted: %s", (Object[])new Object[]{this.toFullCode().generate(), errorMessage});
        }
    }

    protected abstract String getInvertibleError();

    public boolean hasConditionalDependant() {
        for (Dependency dependency : this.getDependants()) {
            Expr dependant = dependency.getDependant();
            if (!dependant.isConditional() || !(dependant instanceof TernaryExpr)) continue;
            TernaryExpr ternary = (TernaryExpr)dependant;
            return ternary.getPred() == this;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean recursivelyInjectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
        this.getResolvedType();
        try {
            Scope.enter((ScopeProvider)this);
            this.mUnboxedAChild = false;
            for (int i = this.getChildren().size() - 1; i >= 0; --i) {
                Expr child = this.getChildren().get(i);
                child.recursivelyInjectSafeUnboxing(modelAnalyzer, model);
                this.mUnboxedAChild |= child.mUnboxedAChild;
            }
            if (this.mUnboxedAChild) {
                this.resetResolvedType();
                this.getResolvedType();
                this.mUnboxedAChild = false;
            }
            this.injectSafeUnboxing(modelAnalyzer, model);
            if (this.mUnboxedAChild) {
                this.resetResolvedType();
                this.getResolvedType();
            }
        }
        finally {
            Scope.exit();
        }
        return this.mUnboxedAChild;
    }

    public Expr unwrapObservableField() {
        String simpleGetterName;
        Expr expr = this;
        while ((simpleGetterName = expr.getResolvedType().getObservableGetterName()) != null) {
            MethodCallExpr unwrapped = this.mModel.methodCall(expr, simpleGetterName, Collections.EMPTY_LIST);
            this.mModel.bindingExpr(unwrapped);
            unwrapped.setUnwrapObservableFields(false);
            expr = unwrapped;
        }
        return expr;
    }

    protected void unwrapObservableFieldChildren() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            this.unwrapChildTo(i, null);
        }
    }

    protected void unwrapChildTo(int childIndex, ModelClass type) {
        String simpleGetterName;
        Expr child = this.mChildren.get(childIndex);
        Expr unwrapped = null;
        Expr expr = child;
        while ((simpleGetterName = expr.getResolvedType().getObservableGetterName()) != null && Expr.shouldUnwrap(type, expr.getResolvedType())) {
            unwrapped = this.mModel.methodCall(expr, simpleGetterName, Collections.EMPTY_LIST);
            if (unwrapped == this) {
                L.w((String)ErrorMessages.OBSERVABLE_FIELD_GET, (Object[])new Object[]{this});
                return;
            }
            unwrapped.setUnwrapObservableFields(false);
            expr = unwrapped;
        }
        if (unwrapped != null) {
            child.getParents().remove(this);
            unwrapped.getParents().add(this);
            this.mChildren.set(childIndex, unwrapped);
        }
    }

    private static boolean shouldUnwrap(ModelClass from, ModelClass to) {
        return (to == null || to.isObject() || !to.isAssignableFrom(from)) && !ModelMethod.isImplicitConversion(from, to);
    }

    protected abstract void injectSafeUnboxing(ModelAnalyzer var1, ExprModel var2);

    static class Node {
        BitSet mBitSet = new BitSet();
        List<Node> mParents = new ArrayList<Node>();
        int mConditionFlag = -1;

        Node() {
        }

        public boolean areAllPathsSatisfied(BitSet readSoFar) {
            if (this.mConditionFlag != -1) {
                return readSoFar.get(this.mConditionFlag) || this.mParents.get(0).areAllPathsSatisfied(readSoFar);
            }
            BitSet myBitsClone = (BitSet)this.mBitSet.clone();
            myBitsClone.andNot(readSoFar);
            if (!myBitsClone.isEmpty()) {
                if (this.mParents.size() == 1 && this.mParents.get((int)0).mConditionFlag != -1) {
                    return this.mParents.get(0).areAllPathsSatisfied(readSoFar);
                }
                return false;
            }
            if (this.mParents.isEmpty()) {
                return true;
            }
            for (Node parent : this.mParents) {
                if (parent.areAllPathsSatisfied(readSoFar)) continue;
                return false;
            }
            return true;
        }

        public void setConditionFlag(int requirementFlagIndex) {
            this.mConditionFlag = requirementFlagIndex;
        }
    }
}

