/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.BindingTarget;
import android.databinding.tool.CallbackWrapper;
import android.databinding.tool.InverseBinding;
import android.databinding.tool.expr.ArgListExpr;
import android.databinding.tool.expr.BitShiftExpr;
import android.databinding.tool.expr.BracketExpr;
import android.databinding.tool.expr.BuiltInVariableExpr;
import android.databinding.tool.expr.CallbackExprModel;
import android.databinding.tool.expr.CastExpr;
import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.FieldAccessExpr;
import android.databinding.tool.expr.FieldAssignmentExpr;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.expr.InstanceOfExpr;
import android.databinding.tool.expr.LambdaExpr;
import android.databinding.tool.expr.ListenerExpr;
import android.databinding.tool.expr.MathExpr;
import android.databinding.tool.expr.MethodCallExpr;
import android.databinding.tool.expr.MethodReferenceExpr;
import android.databinding.tool.expr.ResourceExpr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.expr.SymbolExpr;
import android.databinding.tool.expr.TernaryExpr;
import android.databinding.tool.expr.TwoWayListenerExpr;
import android.databinding.tool.expr.UnaryExpr;
import android.databinding.tool.expr.ViewFieldExpr;
import android.databinding.tool.reflection.ImportBag;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.MutableImportBag;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.ExprModelExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.jetbrains.annotations.Nullable;

public class ExprModel {
    public static final String SAFE_UNBOX_METHOD_NAME = "safeUnbox";
    Map<String, Expr> mExprMap = new HashMap<String, Expr>();
    List<Expr> mBindingExpressions = new ArrayList<Expr>();
    private int mInvalidateableFieldLimit = 0;
    private int mRequirementIdCount = 0;
    private int mArgListIdCounter = 0;
    private static final String TRUE_KEY_SUFFIX = "== true";
    private static final String FALSE_KEY_SUFFIX = "== false";
    private BitSet mInvalidateAnyFlags;
    private int mInvalidateAnyFlagIndex;
    private List<Expr> mPendingExpressions;
    private String[] mFlagMapping;
    private int mFlagBucketCount;
    private List<Expr> mObservables;
    private boolean mSealed = false;
    private MutableImportBag mImports = new MutableImportBag();
    private ParserRuleContext mCurrentParserContext;
    private Location mCurrentLocationInFile;
    private Map<String, CallbackWrapper> mCallbackWrappers = new HashMap<String, CallbackWrapper>();
    private AtomicInteger mCallbackIdCounter = new AtomicInteger();
    private ExprModelExt mExt = new ExprModelExt();
    public final String modulePackage;
    public final boolean enableV2;

    public ExprModel(String modulePackage, boolean enableV2) {
        this.modulePackage = modulePackage;
        this.enableV2 = enableV2;
    }

    public <T extends Expr> T register(T expr) {
        Expr existing;
        Preconditions.check((!this.mSealed ? 1 : 0) != 0, (String)"Cannot add expressions to a model after it is sealed", (Object[])new Object[0]);
        Location location = null;
        if (this.mCurrentParserContext != null) {
            location = new Location(this.mCurrentParserContext);
            location.setParentLocation(this.mCurrentLocationInFile);
        }
        if ((existing = this.mExprMap.get(expr.getUniqueKey())) == null && expr instanceof IdentifierExpr && !(expr instanceof StaticIdentifierExpr)) {
            IdentifierExpr id = (IdentifierExpr)expr;
            existing = this.lazyImportFromJavaLang(id.getName());
        }
        if (existing != null) {
            Preconditions.check((boolean)expr.getParents().isEmpty(), (String)"If an expression already exists, it should've never been added to a parent,if thats the case, somewhere we are creating an expression w/ocalling expression model", (Object[])new Object[0]);
            expr.onSwappedWith(existing);
            if (location != null) {
                existing.addLocation(location);
            }
            return (T)existing;
        }
        this.mExprMap.put(expr.getUniqueKey(), expr);
        expr.setModel(this);
        if (location != null) {
            expr.addLocation(location);
        }
        return expr;
    }

    protected void markSealed() {
        this.mSealed = true;
    }

    public ExprModelExt getExt() {
        return this.mExt;
    }

    public int obtainCallbackId() {
        return this.mCallbackIdCounter.incrementAndGet();
    }

    public void setCurrentParserContext(ParserRuleContext currentParserContext) {
        this.mCurrentParserContext = currentParserContext;
    }

    public ParserRuleContext getCurrentParserContext() {
        return this.mCurrentParserContext;
    }

    public Location getCurrentLocationInFile() {
        return this.mCurrentLocationInFile;
    }

    public Map<String, Expr> getExprMap() {
        return this.mExprMap;
    }

    public int size() {
        return this.mExprMap.size();
    }

    public ComparisonExpr comparison(String op, Expr left, Expr right) {
        return this.register(new ComparisonExpr(op, left, right));
    }

    public InstanceOfExpr instanceOfOp(Expr expr, String type) {
        return this.register(new InstanceOfExpr(expr, type));
    }

    public FieldAccessExpr field(Expr parent, String name) {
        return this.register(new FieldAccessExpr(parent, name));
    }

    public MethodReferenceExpr methodReference(Expr parent, String name) {
        return this.register(new MethodReferenceExpr(parent, name));
    }

    public SymbolExpr symbol(String text, Class type) {
        return this.register(new SymbolExpr(text, type));
    }

    public TernaryExpr ternary(Expr pred, Expr ifTrue, Expr ifFalse) {
        return this.register(new TernaryExpr(pred, ifTrue, ifFalse, TernaryExpr.Type.LAYOUT_EXPRESSION));
    }

    public IdentifierExpr identifier(String name) {
        return this.register(new IdentifierExpr(name));
    }

    public StaticIdentifierExpr staticIdentifier(String name) {
        return this.register(new StaticIdentifierExpr(name));
    }

    public BuiltInVariableExpr builtInVariable(String name, String type, String accessCode) {
        return this.register(new BuiltInVariableExpr(name, type, accessCode));
    }

    public ViewFieldExpr viewFieldExpr(BindingTarget bindingTarget) {
        return this.register(new ViewFieldExpr(bindingTarget));
    }

    public IdentifierExpr viewDataBinding() {
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        String qualifiedName = analyzer.libTypes.getViewDataBinding();
        StaticIdentifierExpr viewDataBinding = this.staticIdentifier(qualifiedName);
        viewDataBinding.setUserDefinedType(qualifiedName);
        return viewDataBinding;
    }

    public MethodCallExpr safeUnbox(Expr expr) {
        ModelClass resolvedType = expr.getResolvedType();
        Preconditions.check((resolvedType.unbox() != resolvedType ? 1 : 0) != 0, (String)"Cannot call 'safeUnbox' on '%s' as it is not a boxed, primitive type", (Object[])new Object[]{resolvedType});
        MethodCallExpr methodCallExpr = this.methodCall(this.viewDataBinding(), SAFE_UNBOX_METHOD_NAME, Collections.singletonList(expr));
        methodCallExpr.setAllowProtected();
        for (Location location : expr.getLocations()) {
            methodCallExpr.addLocation(location);
        }
        return methodCallExpr;
    }

    public Expr globalMethodCall(String methodName, List<Expr> args2) {
        Preconditions.check((boolean)SAFE_UNBOX_METHOD_NAME.equals(methodName), (String)"Cannot find method '%s::%s'", (Object[])new Object[]{"ViewDataBinding", methodName});
        Preconditions.check((args2.size() == 1 ? 1 : 0) != 0, (String)"Unexpected parameter count\n\nExpected: %d\nFound: %d", (Object[])new Object[]{1, args2.size()});
        MethodCallExpr expr = this.methodCall(this.viewDataBinding(), SAFE_UNBOX_METHOD_NAME, args2);
        expr.setAllowProtected();
        return expr;
    }

    public StaticIdentifierExpr staticIdentifierFor(ModelClass modelClass) {
        String type = modelClass.getCanonicalName();
        StaticIdentifierExpr id = this.findStaticIdentifierExpr(type);
        if (id != null) {
            return id;
        }
        int cnt = 0;
        int dotIndex = type.lastIndexOf(".");
        Preconditions.check((dotIndex < type.length() - 1 ? 1 : 0) != 0, (String)"Invalid type %s", (Object[])new Object[]{type});
        String baseName = dotIndex == -1 ? type : type.substring(dotIndex + 1);
        while (true) {
            String candidate;
            String string = candidate = cnt == 0 ? baseName : baseName + cnt;
            if (!this.mImports.contains(candidate)) {
                return this.addImport(candidate, type, null);
            }
            Preconditions.check((++cnt < 100 ? 1 : 0) != 0, (String)("Failed to create an import for " + type), (Object[])new Object[0]);
        }
    }

    @Nullable
    private StaticIdentifierExpr findStaticIdentifierExpr(String type) {
        for (Expr expr : this.mExprMap.values()) {
            StaticIdentifierExpr id;
            if (!(expr instanceof StaticIdentifierExpr) || !(id = (StaticIdentifierExpr)expr).getUserDefinedType().equals(type)) continue;
            return id;
        }
        return null;
    }

    public MethodCallExpr methodCall(Expr target, String name, List<Expr> args2) {
        return this.register(new MethodCallExpr(target, name, args2));
    }

    public MathExpr math(Expr left, String op, Expr right) {
        return this.register(new MathExpr(left, op, right));
    }

    public TernaryExpr logical(Expr left, String op, Expr right) {
        if ("&&".equals(op)) {
            return this.register(new TernaryExpr(left, right, (Expr)this.symbol("false", Boolean.TYPE), TernaryExpr.Type.LOGICAL_EXPRESSION));
        }
        return this.register(new TernaryExpr(left, (Expr)this.symbol("true", Boolean.TYPE), right, TernaryExpr.Type.LOGICAL_EXPRESSION));
    }

    public BitShiftExpr bitshift(Expr left, String op, Expr right) {
        return this.register(new BitShiftExpr(left, op, right));
    }

    public UnaryExpr unary(String op, Expr expr) {
        return this.register(new UnaryExpr(op, expr));
    }

    public Expr resourceExpr(BindingTarget target, String packageName, String resourceType, String resourceName, List<Expr> args2) {
        return this.register(new ResourceExpr(target, packageName, resourceType, resourceName, args2));
    }

    public Expr bracketExpr(Expr variableExpr, Expr argExpr) {
        return this.register(new BracketExpr(variableExpr, argExpr));
    }

    public Expr castExpr(String type, Expr expr) {
        return this.register(new CastExpr(type, expr));
    }

    public TwoWayListenerExpr twoWayListenerExpr(InverseBinding inverseBinding) {
        return this.register(new TwoWayListenerExpr(inverseBinding));
    }

    public List<Expr> getBindingExpressions() {
        return this.mBindingExpressions;
    }

    public StaticIdentifierExpr addImport(String alias, String type, Location location) {
        String existing = this.mImports.find(alias);
        if (existing != null) {
            if (existing.equals(type)) {
                StaticIdentifierExpr id = this.findStaticIdentifierExpr(type);
                Preconditions.checkNotNull((Object)id, (String)"Missing import expression although it is registered", (Object[])new Object[0]);
                return id;
            }
            L.e((String)"%s has already been defined as %s but trying to re-define as %s", (Object[])new Object[]{alias, existing, type});
        }
        StaticIdentifierExpr id = this.staticIdentifier(alias);
        L.d((String)"adding import %s as %s klass: %s", (Object[])new Object[]{type, alias, id.getClass().getSimpleName()});
        id.setUserDefinedType(type);
        if (location != null) {
            id.addLocation(location);
        }
        this.mImports.put(alias, type);
        return id;
    }

    public ImportBag getImports() {
        return this.mImports;
    }

    public Expr bindingExpr(Expr bindingExpr) {
        Preconditions.check((boolean)this.mExprMap.containsKey(bindingExpr.getUniqueKey()), (String)"Main expression should already be registered", (Object[])new Object[0]);
        if (!this.mBindingExpressions.contains(bindingExpr)) {
            this.mBindingExpressions.add(bindingExpr);
        }
        bindingExpr.markAsBindingExpression();
        return bindingExpr;
    }

    public void removeExpr(Expr expr) {
        Preconditions.check((!this.mSealed ? 1 : 0) != 0, (String)"Can't modify the expression list after sealing the model.", (Object[])new Object[0]);
        this.mBindingExpressions.remove(expr);
        this.mExprMap.remove(expr.getUniqueKey());
    }

    public List<Expr> getObservables() {
        return this.mObservables;
    }

    /*
     * WARNING - void declaration
     */
    public void seal() {
        void var8_26;
        void var7_12;
        L.d((String)"sealing model", (Object[])new Object[0]);
        this.resolveTypes();
        ArrayList<Expr> notifiableExpressions = new ArrayList<Expr>();
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        this.updateExpressions(modelAnalyzer);
        int counter = 0;
        Iterable<Expr> observables = this.filterObservables();
        ArrayList<String> flagMapping2 = new ArrayList<String>();
        this.mObservables = new ArrayList<Expr>();
        for (Expr expr : observables) {
            flagMapping2.add(expr.getUniqueKey());
            expr.setId(counter++);
            this.mObservables.add(expr);
            notifiableExpressions.add(expr);
            L.d((String)"observable %s", (Object[])new Object[]{expr.toString()});
        }
        List<Expr> nonObservableIds = this.filterNonObservableIds(modelAnalyzer);
        for (Expr expr : nonObservableIds) {
            flagMapping2.add(expr.getUniqueKey());
            expr.setId(counter++);
            notifiableExpressions.add(expr);
            L.d((String)"non-observable %s", (Object[])new Object[]{expr.toString()});
        }
        for (Expr expr : observables) {
            for (Expr parent : expr.getParents()) {
                if (parent.hasId() || !(parent instanceof FieldAccessExpr)) continue;
                FieldAccessExpr fae = (FieldAccessExpr)parent;
                L.d((String)"checking field access expr %s. getter: %s", (Object[])new Object[]{fae, fae.getGetter()});
                if (fae.getGetter() == null || !fae.isDynamic() || !fae.getGetter().canBeInvalidated()) continue;
                flagMapping2.add(parent.getUniqueKey());
                parent.setId(counter++);
                notifiableExpressions.add(parent);
                L.d((String)"notifiable field %s : %s for %s : %s", (Object[])new Object[]{parent.toString(), Integer.toHexString(System.identityHashCode(parent)), expr.getUniqueKey(), Integer.toHexString(System.identityHashCode(expr))});
            }
        }
        for (Expr expr : this.mExprMap.values()) {
            FieldAccessExpr fieldAccessExpr;
            if (!(expr instanceof FieldAccessExpr) || !((fieldAccessExpr = (FieldAccessExpr)expr).getTarget() instanceof ViewFieldExpr)) continue;
            flagMapping2.add(fieldAccessExpr.getUniqueKey());
            fieldAccessExpr.setId(counter++);
        }
        L.d((String)"list of binding expressions", (Object[])new Object[0]);
        boolean bl = false;
        while (var7_12 < this.mBindingExpressions.size()) {
            L.d((String)"[%d] %s", (Object[])new Object[]{(int)var7_12, this.mBindingExpressions.get((int)var7_12)});
            ++var7_12;
        }
        for (Expr expr : notifiableExpressions) {
            expr.enableDirectInvalidation();
        }
        for (Expr expr : this.mExprMap.values()) {
            expr.getDependencies();
        }
        this.mInvalidateAnyFlagIndex = counter++;
        flagMapping2.add("INVALIDATE ANY");
        this.mInvalidateableFieldLimit = counter;
        BitSet bitSet = new BitSet();
        boolean bl2 = false;
        while (var8_26 < this.mInvalidateableFieldLimit) {
            bitSet.set((int)var8_26, true);
            ++var8_26;
        }
        for (Expr expr : this.mExprMap.values()) {
            if (!expr.isConditional()) continue;
            L.d((String)"requirement id for %s is %d", (Object[])new Object[]{expr, counter});
            expr.setRequirementId(counter);
            flagMapping2.add(expr.getUniqueKey() + FALSE_KEY_SUFFIX);
            flagMapping2.add(expr.getUniqueKey() + TRUE_KEY_SUFFIX);
            counter += 2;
        }
        BitSet bitSet2 = new BitSet();
        for (int i = this.mInvalidateableFieldLimit; i < counter; ++i) {
            bitSet2.set(i, true);
        }
        this.mRequirementIdCount = (counter - this.mInvalidateableFieldLimit) / 2;
        for (Map.Entry<String, Expr> entry : this.mExprMap.entrySet()) {
            Expr value = entry.getValue();
            if (value.hasId()) continue;
            value.setId(counter++);
        }
        this.mFlagMapping = new String[flagMapping2.size()];
        flagMapping2.toArray(this.mFlagMapping);
        this.mFlagBucketCount = 1 + this.getTotalFlagCount() / 64;
        this.mInvalidateAnyFlags = new BitSet();
        this.mInvalidateAnyFlags.set(this.mInvalidateAnyFlagIndex, true);
        for (Expr expr : this.mExprMap.values()) {
            expr.getShouldReadFlagsWithConditionals();
        }
        for (Expr expr : this.mExprMap.values()) {
            expr.getResolvedType();
        }
        this.mSealed = true;
    }

    private void updateExpressions(ModelAnalyzer modelAnalyzer) {
        int startSize = -1;
        while (startSize != this.mExprMap.size()) {
            startSize = this.mExprMap.size();
            ArrayList<Expr> exprs = new ArrayList<Expr>(this.mBindingExpressions);
            for (Expr expr : exprs) {
                expr.updateExpr(modelAnalyzer);
            }
        }
        this.injectSafeUnboxing(modelAnalyzer);
    }

    private void injectSafeUnboxing(ModelAnalyzer modelAnalyzer) {
        ArrayList<Expr> expressions = new ArrayList<Expr>(this.mBindingExpressions);
        for (Expr expr : expressions) {
            expr.recursivelyInjectSafeUnboxing(modelAnalyzer, this);
        }
    }

    public int getFlagBucketCount() {
        return this.mFlagBucketCount;
    }

    public int getTotalFlagCount() {
        return this.mRequirementIdCount * 2 + this.mInvalidateableFieldLimit;
    }

    public int getInvalidateableFieldLimit() {
        return this.mInvalidateableFieldLimit;
    }

    public String[] getFlagMapping() {
        return this.mFlagMapping;
    }

    public String getFlag(int id) {
        return this.mFlagMapping[id];
    }

    private List<Expr> filterNonObservableIds(ModelAnalyzer modelAnalyzer) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr input : this.mExprMap.values()) {
            if (!(input instanceof IdentifierExpr) || input.hasId() || input.isObservable() || !input.isDynamic()) continue;
            result.add(input);
        }
        return result;
    }

    private Iterable<Expr> filterObservables() {
        return this.mExprMap.values().stream().filter(expr -> expr.isObservable()).collect(Collectors.toList());
    }

    private void resolveTypes() {
        int numExpressions;
        do {
            numExpressions = this.mExprMap.size();
            this.mExprMap.values().stream().collect(Collectors.toList()).forEach(expr -> expr.getResolvedType());
        } while (this.mExprMap.size() != numExpressions);
    }

    public List<Expr> getPendingExpressions() {
        if (this.mPendingExpressions == null) {
            this.mPendingExpressions = new ArrayList<Expr>();
            for (Expr expr : this.mExprMap.values()) {
                if (expr.isRead() || !expr.isDynamic() && !expr.hasConditionalDependant()) continue;
                this.mPendingExpressions.add(expr);
            }
        }
        return this.mPendingExpressions;
    }

    public boolean markBitsRead() {
        ArrayList<Expr> markedSomeFlagsRead = new ArrayList<Expr>();
        for (Expr expr : ExprModel.filterShouldRead(this.getPendingExpressions())) {
            expr.markFlagsAsRead(expr.getShouldReadFlags());
            markedSomeFlagsRead.add(expr);
        }
        return this.pruneDone(markedSomeFlagsRead);
    }

    private boolean pruneDone(List<Expr> markedSomeFlagsAsRead) {
        boolean marked = true;
        ArrayList<Expr> markedAsReadList = new ArrayList<Expr>();
        while (marked) {
            marked = false;
            for (Expr expr : this.mExprMap.values()) {
                if (expr.isRead() || !expr.markAsReadIfDone()) continue;
                L.d((String)"marked %s as read ", (Object[])new Object[]{expr.toString()});
                marked = true;
                markedAsReadList.add(expr);
                markedSomeFlagsAsRead.remove(expr);
            }
        }
        boolean elevated = false;
        for (Expr markedAsRead : markedAsReadList) {
            for (Dependency dependency : markedAsRead.getDependants()) {
                if (!dependency.getDependant().considerElevatingConditionals(markedAsRead)) continue;
                elevated = true;
            }
        }
        if (!elevated) {
            for (Expr partialRead : markedSomeFlagsAsRead) {
                for (Dependency dependency : partialRead.getDependants()) {
                    Expr dependant = dependency.getDependant();
                    if (!dependant.isConditional() || !dependant.getAllCalculationPaths().areAllPathsSatisfied(partialRead.mReadSoFar) || !dependant.considerElevatingConditionals(partialRead)) continue;
                    elevated = true;
                }
            }
        }
        if (elevated) {
            for (Expr expr : this.getPendingExpressions()) {
                if (expr.isRead()) continue;
                expr.invalidateReadFlags();
            }
            this.mPendingExpressions = null;
        }
        return elevated;
    }

    private static boolean hasConditionalOrNestedCannotReadDependency(Expr expr) {
        for (Dependency dependency : expr.getDependencies()) {
            if (!dependency.isConditional() && !dependency.getOther().hasNestedCannotRead()) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<Expr> filterShouldRead(Iterable<Expr> exprs) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            if (expr.getShouldReadFlags().isEmpty() || ExprModel.hasConditionalOrNestedCannotReadDependency(expr)) continue;
            result.add(expr);
        }
        return result;
    }

    public Expr findFlagExpression(int flag) {
        if (this.mInvalidateAnyFlags.get(flag)) {
            return null;
        }
        String key = this.mFlagMapping[flag];
        if (this.mExprMap.containsKey(key)) {
            return this.mExprMap.get(key);
        }
        int falseIndex = key.indexOf(FALSE_KEY_SUFFIX);
        if (falseIndex > -1) {
            String trimmed = key.substring(0, falseIndex);
            return this.mExprMap.get(trimmed);
        }
        int trueIndex = key.indexOf(TRUE_KEY_SUFFIX);
        if (trueIndex > -1) {
            String trimmed = key.substring(0, trueIndex);
            return this.mExprMap.get(trimmed);
        }
        StringBuilder error = new StringBuilder();
        error.append("cannot find flag:").append(flag).append("\n");
        error.append("invalidate any flag:").append(this.mInvalidateAnyFlags).append("\n");
        error.append("key:").append(key).append("\n");
        error.append("flag mapping:").append(Arrays.toString(this.mFlagMapping));
        L.e((String)error.toString(), (Object[])new Object[0]);
        return null;
    }

    public BitSet getInvalidateAnyBitSet() {
        return this.mInvalidateAnyFlags;
    }

    public int getInvalidateAnyFlagIndex() {
        return this.mInvalidateAnyFlagIndex;
    }

    public Expr argListExpr(Iterable<Expr> expressions) {
        return this.register(new ArgListExpr(this.mArgListIdCounter++, expressions));
    }

    public void setCurrentLocationInFile(Location location) {
        this.mCurrentLocationInFile = location;
    }

    public Expr listenerExpr(Expr expression, String name, ModelClass listenerType, ModelMethod listenerMethod) {
        return this.register(new ListenerExpr(expression, name, listenerType, listenerMethod));
    }

    public FieldAssignmentExpr assignment(Expr target, String name, Expr value) {
        return this.register(new FieldAssignmentExpr(target, name, value));
    }

    public Map<String, CallbackWrapper> getCallbackWrappers() {
        return this.mCallbackWrappers;
    }

    public CallbackWrapper callbackWrapper(ModelClass klass, ModelMethod method) {
        String key = CallbackWrapper.uniqueKey(klass, method);
        CallbackWrapper wrapper = this.mCallbackWrappers.get(key);
        if (wrapper == null) {
            wrapper = new CallbackWrapper(klass, method, this.modulePackage, this.enableV2);
            this.mCallbackWrappers.put(key, wrapper);
        }
        return wrapper;
    }

    public LambdaExpr lambdaExpr(Expr expr, CallbackExprModel callbackExprModel) {
        return this.register(new LambdaExpr(expr, callbackExprModel));
    }

    public IdentifierExpr findIdentifier(String name) {
        for (Expr expr : this.mExprMap.values()) {
            if (!(expr instanceof IdentifierExpr) || !name.equals(((IdentifierExpr)expr).getName())) continue;
            return (IdentifierExpr)expr;
        }
        return this.lazyImportFromJavaLang(name);
    }

    @Nullable
    private StaticIdentifierExpr lazyImportFromJavaLang(String name) {
        if (ImportBag.JAVA_LANG_IMPORTS.contains(name)) {
            StaticIdentifierExpr id = this.staticIdentifier(name);
            L.d((String)"adding java lang import %s", (Object[])new Object[]{name});
            id.setUserDefinedType("java.lang." + name);
            return id;
        }
        return null;
    }
}

